package com.fos.modules.userOrder.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fos.core.base.CurdService;
import com.fos.modules.userOrder.bean.FoodPreBean;
import com.fos.modules.userOrder.bean.TasteBean;
import com.fos.modules.userOrder.bean.UserOrderBean;
import com.fos.modules.userOrder.bean.VipFoodBean;
import com.fos.modules.userOrder.dao.UserOrderDao;
import com.fos.modules.userOrder.entity.UserOrderEntity;
import com.fos.modules.userOrder.entity.UserPreNumEntity;

@Service
public class UserOrderService extends CurdService<UserOrderDao, UserOrderEntity> {

	private final static Logger log = LoggerFactory.getLogger(UserOrderService.class);

	// 根据座位号查询userId 
	@Transactional(readOnly = false)
	public UserOrderEntity getUserId(UserOrderBean userOrderBean) {

		UserOrderEntity userOrderEntity = dao.getUserId(userOrderBean);

		log.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~userOrderEntity.getOrderId():::"
				+ userOrderEntity);
		if (userOrderEntity != null) {
			userOrderBean.setUserId(userOrderEntity.getUserId());
		}
		return userOrderEntity;

	}
	// 根据座位号查询 seatid
	public UserOrderEntity getSeatId(UserOrderBean userOrderBean) {

		UserOrderEntity userOrderEntity = dao.getSeatId(userOrderBean);

		log.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~userOrderEntity.getOrderId():::"
				+ userOrderEntity);
		if (userOrderEntity != null) {
			userOrderBean.setSeatId(userOrderEntity.getSeatId());
		}
		return userOrderEntity;

	}
	public UserOrderEntity getOrderId(UserOrderBean userOrderBean) {

		UserOrderEntity userOrderEntity = dao.getOrderId(userOrderBean);

		// log.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~userOrderEntity.getOrderId():::"
			//	+ userOrderEntity);
		if (userOrderEntity != null) {
			userOrderBean.setOrderId(userOrderEntity.getOrderId());
		}
		return userOrderEntity;

	}

	// 根据orderId插入order表(seatid、userid、等)
	@Transactional(readOnly = false)
	public int addUserOrderTable(UserOrderBean userOrderBean) {
		
		 int userOrderTable = dao.addUserOrderTable(userOrderBean);
		return userOrderTable;
	}
	
	// 根据userId插入用户喜爱的foodId和foodNum
	@Transactional(readOnly = false)
	public int addUserOrderFood(UserOrderBean userOrderBean) {
		
		 int getUserOrderFood = dao.addUserOrderFood(userOrderBean);
		return getUserOrderFood;
	}

	//将内容插入到vip_order2food中
	@Transactional(readOnly = false)
	public int addOrderAndFood(UserOrderBean userOrderBean) {

		int	addOrderAndFood = dao.addOrderAndFood(userOrderBean);
		return addOrderAndFood;
	}

	// 批量插入用户偏爱食物的 vip_orderfood2pre表
	@Transactional(readOnly = false)
	public int addFoodTaste(TasteBean tasteBean ){
		
		int getFoodTaste = dao.addFoodTaste(tasteBean);
			
		return getFoodTaste;
	}
	
	//查询preNum
	public List<UserOrderBean> getPreNum(UserOrderBean userOrderBean){
		return dao.getPreNum(userOrderBean);
	}
	
	// 根据订单号查询订单次数
	@Transactional(readOnly = false)
	public UserOrderEntity getOrderCount(UserOrderBean userOrderBean) {
		UserOrderEntity userOrderEntity = dao.getOrderCount(userOrderBean);
		if(userOrderEntity!=null){
			return userOrderEntity;
		}
		return userOrderEntity;

	}

	// 根据foodName查询foodnum,为修改vip_user2food数量
	@Transactional(readOnly = false)
	public UserOrderEntity getPreFoodNum(UserOrderBean userOrderBean) {

		UserOrderEntity userOrderEntity = dao.getPreFoodNum(userOrderBean);
		if(userOrderEntity!=null){
			return userOrderEntity;
		}
		return userOrderEntity;
	}

	// 如果菜品名不为空，在vip_order_food中更新该菜品名的数量，并让订单次数+1
	@Transactional(readOnly = false)
	public int updateFoodMenuNumToOrder(UserOrderBean userOrderBean) {
		int updateFoodMenuNumToOrder = 0;
		List<VipFoodBean> vipFoodList = userOrderBean.getFoodList();
		for(VipFoodBean vipFood:vipFoodList){
			userOrderBean.setFoodId(vipFood.getFoodId());
			userOrderBean.setFoodNum(vipFood.getFoodNum());
			updateFoodMenuNumToOrder = dao.updateFoodMenuNumToOrder(userOrderBean);
			updateFoodMenuNumToOrder++;
		}
		return updateFoodMenuNumToOrder;
	}
	// 如果菜品名不为空，在vip_user_food中更新该菜品名的数量，并让订单次数+1
	@Transactional(readOnly = false)
	public int updateFoodMenuNum(VipFoodBean vipFoodBean,UserOrderBean userOrderBean) {
		int updateFoodMenuNum = 0;
		List<VipFoodBean> vipFoodList = userOrderBean.getFoodList();
		for(VipFoodBean vipFood:vipFoodList){
			userOrderBean.setFoodId(vipFood.getFoodId());
			userOrderBean.setFoodNum(vipFood.getFoodNum());
			updateFoodMenuNum = dao.updateFoodMenuNum(userOrderBean);
		}
		return updateFoodMenuNum;
	}

	// 更新vip_order2food表中的count
	@Transactional(readOnly = false)
	public int updateOrderCount(UserOrderBean userOrderBean) {
		int updateOrderCount = dao.updateOrderCount(userOrderBean);
		if(updateOrderCount>0){
			return updateOrderCount;
		}
		return updateOrderCount;
	}

	//插入userId、preid、preNum
	@Transactional(readOnly = false)
	public int addUserPreferenceFood(UserOrderBean userOrderBean) {
		
		int addUserPreferenceFood = 0;
		if(userOrderBean.getUserId()>0 &&userOrderBean.getFoodList()!=null){
			addUserPreferenceFood = dao.addUserPreferenceFood(userOrderBean);
		}
		return addUserPreferenceFood;
	}

	// 更新order表中的下单状态(status)，并把订单表的次数+1
	@Transactional(readOnly = false)
	public int updateOrderStatus(UserOrderBean userOrderBean) {

		int updateOrderStatus = 0;
		// 查询订单次数
		UserOrderEntity userOrderEntity = dao.getOrderCount(userOrderBean);
		if(userOrderEntity!=null){
			int count = userOrderEntity.getCount();
			count = count + 1;
			userOrderBean.setCount(count);
			userOrderBean.setStatus(1);
			updateOrderStatus = dao.updateOrderStatus(userOrderBean);
				return updateOrderStatus;
		}
		return updateOrderStatus;
		
	}
	
	//通过tasteFoodId获取orderFoodId
	@Transactional(readOnly = false)
	public UserPreNumEntity getOrderFoodId(UserOrderBean userOrderBean){
		return dao.getOrderFoodId(userOrderBean);
	}
	
	//查询用户更新时间、创建时间和订单创建时间和更新时间
	public UserPreNumEntity getCode(UserOrderBean userOrderBean){
		return dao.getCode(userOrderBean);
	}
	
	 //查询订单状态
	public UserPreNumEntity getStatus(UserOrderBean userOrderBean){
		return dao.getStatus(userOrderBean);
	}
}
