package com.fos.modules.userOrder.dao;

import java.util.List;

import com.fos.core.base.CurdDao;
import com.fos.modules.userOrder.bean.TasteBean;
import com.fos.modules.userOrder.bean.UserOrderBean;
import com.fos.modules.userOrder.bean.VipFoodBean;
import com.fos.modules.userOrder.entity.UserOrderEntity;
import com.fos.modules.userOrder.entity.UserPreNumEntity;

public interface UserOrderDao extends CurdDao<UserOrderEntity>{

	//根据nickname查询userid
	public UserOrderEntity getUserId(UserOrderBean userOrderBean);
	//根据桌号获取座位号
	public UserOrderEntity getSeatId(UserOrderBean userOrderBean);
	//根据code获取OrderId
	public UserOrderEntity getOrderId(UserOrderBean userOrderBean);
	//根据订单号查询订单次数
	public UserOrderEntity getOrderCount(UserOrderBean userOrderBean);
	//根据orderId插入seatId
	public int addUserOrderTable(UserOrderBean userOrderBean);//将查到的内容放到entity里并插入到order表中
	//批量插入用户偏好食物Id,vip_order2food表id
	public int addFoodTaste(TasteBean tasteBean);
	//根据userId插入用户喜爱的foodId和foodNum
	public int addUserPreferenceFood(UserOrderBean userOrderBean);
	//根据useId批量插入食物id和数量，对vip_user2food表
	public int addUserOrderFood(UserOrderBean userOrderBean);
	//将内容插入到vip_order2food表
	public int addOrderAndFood(UserOrderBean userOrderBean);
	//更改order表中的下单状态(status)
	public int updateOrderStatus(UserOrderBean userOrderBean);
	//根据foodid查询foodnum
	public UserOrderEntity getPreFoodNum(UserOrderBean userOrderBean);
	//如果菜品名不为空，在vip_user_food中更新该菜品名的数量，并让订单次数+1
	public int updateFoodMenuNum(UserOrderBean userOrderBean);
	// 根据id和订单号更新菜品名的数量 vip_order2food表
	public int updateFoodMenuNumToOrder(UserOrderBean userOrderBean);
	//更新vip_order2food表中的count
	public int updateOrderCount(UserOrderBean userOrderBean);
	//根据用户Id查询preId
	public UserOrderEntity getPerferenceId(UserOrderBean userOrderBean);
	//通过tasteFoodId获取orderFoodId
	public UserPreNumEntity getOrderFoodId(UserOrderBean userOrderBean);
	//查询preNum
	public List<UserOrderBean> getPreNum(UserOrderBean userOrderBean);
	//如果用户更新时间大于订单更新时间
	public UserPreNumEntity getCode(UserOrderBean userOrderBean);
	//查询该用户状态和订单状态
	public UserPreNumEntity getStatus(UserOrderBean userOrderBean);
	
	

	

	

}
