package com.fos.modules.userOrder.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.core.util.Util;
import com.fos.modules.userOrder.bean.FoodPreBean;
import com.fos.modules.userOrder.bean.TasteBean;
import com.fos.modules.userOrder.bean.UserOrderBean;
import com.fos.modules.userOrder.bean.VipFoodBean;
import com.fos.modules.userOrder.entity.UserOrderEntity;
import com.fos.modules.userOrder.entity.UserPreNumEntity;
import com.fos.modules.userOrder.service.UserOrderService;

@Controller
@RequestMapping(value = "/api/userOrder")
public class UserOrderController {

	@Autowired
	private UserOrderService userOrderService;

	@ResponseBody
	@RequestMapping(value = "/getUserOrder")
	public ResponseBean getUserOrder(RequestBean requestBean,UserPreNumEntity userPreNumEntity,VipFoodBean vipFoodBean) {

		ResponseBean responseBean = new ResponseBean();
		UserOrderBean userOrderBean = requestBean.getObjectBean(UserOrderBean.class);
		String message = userOrderService.validate(userOrderBean);
		if (message == null) {
			
			//获取用户创建时间和订单创建时间
			UserPreNumEntity userPreNum = userOrderService.getCode(userOrderBean);
			long updateTimeA =0;
			long updateTimeB =0;
			long createTimeA =0;
			long createTimeB =0;
			
			if(userPreNum!=null){
				updateTimeA = userPreNum.getUpdateTimeA();	//用户更新时间
				
				updateTimeB = userPreNum.getUpdateTimeB();   //订单更新时间
				
				createTimeA =  userPreNum.getCreateTimeA();    //用户创建时间

				createTimeB = userPreNum.getCreateTimeB();     //订单创建时间
			}
		
			if(updateTimeA>0){
				updateTimeA = Long.valueOf(userPreNum.getUpdateTimeA()); //用户更新时间
			}
			if(updateTimeB>0){
				updateTimeB =Long.valueOf( userPreNum.getUpdateTimeB());  //订单更新时间
			}
			if(createTimeA>0){
				createTimeA  =Long.valueOf(userPreNum.getCreateTimeA()); //用户创建时间
			}
			if(createTimeB>0){
				createTimeB  =Long.valueOf(userPreNum.getCreateTimeB());  //订单创建时间
			}
			//如果用户创建时间或更新时间比订单的创建时间大，说明先登机再订单，第一次订单
				if(updateTimeA > createTimeB ||createTimeA > createTimeB){
					if (userOrderBean != null){
						
						// 根据昵称查询userId，为获取user_id,往vip_order里插入数据
						UserOrderEntity userIdEntity = userOrderService.getUserId(userOrderBean);
						userOrderBean.setUserId(userIdEntity.getUserId());
						
						// 根据座位号查询seatId，为获取seat_id,往vip_order里插入数据
						UserOrderEntity seatIdEntity = userOrderService.getSeatId(userOrderBean);
						userOrderBean.setSeatId(seatIdEntity.getSeatId());
						
						//查询preNum,为往vip_user2pre表里插入数据
						List<UserOrderBean> preNum = userOrderService.getPreNum(userOrderBean);
						
						//生成订单唯一标识
						String code = Util.getGenericUUID();
						userOrderBean.setCode(code);
						
						for(UserOrderBean userOrderList:preNum){
							if(userOrderList!=null){
								userOrderBean.setPreNum(userOrderList.getPreNum());
							}
						}
						
							// 给vip_order表插入
							int userOrderTable = userOrderService.addUserOrderTable(userOrderBean);
							
							//给vip_user2food表插入
							int userOrderFood = userOrderService.addUserOrderFood(userOrderBean);
							
							
							// 根据用户昵称查询订单次数
							UserOrderEntity userOrderEntity = userOrderService.getOrderCount(userOrderBean);
							if(userOrderEntity!=null){
								userOrderBean.setCount(userOrderEntity.getCount());
							}
							
							//给vip_order_food表插入
							UserOrderEntity orderIdEntity = userOrderService.getOrderId(userOrderBean);
							if(orderIdEntity!=null){
								userOrderBean.setOrderId(orderIdEntity.getOrderId());
							}
							int addOrderAndFood = userOrderService.addOrderAndFood(userOrderBean);
							
							//下面是把口味和偏好放入vip_orderfood_pre表
							List<VipFoodBean> vipFoodList = userOrderBean.getFoodList();
							int classiFy = 0;
							TasteBean tasteBean = new TasteBean ();
							FoodPreBean foodPreBean = new FoodPreBean();
							List<TasteBean> tasteList = new ArrayList<TasteBean>();
							List<FoodPreBean> foodPreList = new ArrayList<FoodPreBean>();
							//获取classiFy的状态
								for(VipFoodBean vipFood:vipFoodList){
									if(vipFood!=null){
										classiFy = vipFood.getClassify();
									}
									
								//classiFy == 0说明是单品
								if(classiFy == 0){
									//食物的Bean
									for(VipFoodBean VipFood:vipFoodList){
										if(VipFood!=null){
											tasteList = VipFood.getTasteList();
											if(tasteList!=null){
												//口味的Bean
												for(TasteBean taste:tasteList){
													if(taste!=null){
														userOrderBean.setTasteFoodId(taste.getTasteFoodId());
													}
													
													//获取getOrderFoodId，为往vip_orderfood2pre表里插入数据
													userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
													if(userPreNumEntity!=null){
														tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
													}
													
													tasteBean.setFoodPreList(taste.getFoodPreList());
													userOrderBean.setRemark(taste.getRemark());
													foodPreList = taste.getFoodPreList();
													if(foodPreList!=null){
														//食物偏好Bean
														for(FoodPreBean foodPre:foodPreList){
															if(foodPre!=null){
																userOrderBean.setPreId(foodPre.getPreId());
																foodPreBean.setPreName(foodPre.getPreName());
																foodPreBean.setPreId(foodPre.getPreId());
															}
														}
													}
												}
											}
											
										}
										for(TasteBean taste:tasteList){
											if(taste!=null){
												userOrderBean.setTasteFoodId(taste.getTasteFoodId());
											}
											//获取getOrderFoodId，为往vip_orderfood2pre表里插入数据
											userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
											if(userPreNumEntity!=null){
												tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
												tasteBean.setFoodPreList(taste.getFoodPreList());
												userOrderBean.setRemark(taste.getRemark());
												foodPreList = taste.getFoodPreList();
											}
											
											if(foodPreList!=null){
												for(FoodPreBean foodPre:foodPreList){
													if(foodPre!=null){
														userOrderBean.setPreId(foodPre.getPreId());
														foodPreBean.setPreName(foodPre.getPreName());
														foodPreBean.setPreId(foodPre.getPreId());
													}
												}
											}
										}
										if(tasteList.size()>0 ){
											//往vip_orderfood2pre表里插入数据
											int foodTaste = userOrderService.addFoodTaste(tasteBean);
										}
									}
									if(tasteList.size()>0 ){
										//给user2pre表插入
										int addUserPreferenceFood = userOrderService.addUserPreferenceFood(userOrderBean);
									}
								//如果classiFy == 1，是套餐，将食物、口味插入数据库，同上
								}else if(classiFy == 1){
									for(VipFoodBean VipFood:vipFoodList){
										if(VipFood!=null){
											tasteList = VipFood.getTasteList();
											if(tasteList!=null){
												for(TasteBean taste:tasteList){
													if(taste!=null){
														userOrderBean.setTasteFoodId(taste.getTasteFoodId());
													}
													userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
													if(userPreNumEntity!=null){
														tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
													}
													
													tasteBean.setFoodPreList(taste.getFoodPreList());
													userOrderBean.setRemark(taste.getRemark());
													foodPreList = taste.getFoodPreList();
													if(foodPreList!=null){
														for(FoodPreBean foodPre:foodPreList){
															if(foodPre!=null){
																userOrderBean.setPreId(foodPre.getPreId());
																foodPreBean.setPreName(foodPre.getPreName());
																foodPreBean.setPreId(foodPre.getPreId());
															}
														}
													}
												}
											}
											
										}
										for(TasteBean taste:tasteList){
											if(taste!=null){
												userOrderBean.setTasteFoodId(taste.getTasteFoodId());
											}
											userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
											if(userPreNumEntity!=null){
												tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
												tasteBean.setFoodPreList(taste.getFoodPreList());
												userOrderBean.setRemark(taste.getRemark());
												foodPreList = taste.getFoodPreList();
											}
											
											if(foodPreList!=null){
												for(FoodPreBean foodPre:foodPreList){
													if(foodPre!=null){
														userOrderBean.setPreId(foodPre.getPreId());
														foodPreBean.setPreName(foodPre.getPreName());
														foodPreBean.setPreId(foodPre.getPreId());
													}
												}
											}
										}
										if(tasteList.size()>0 ){
											//往vip_orderfood2pre表里插入数据
											int foodTaste = userOrderService.addFoodTaste(tasteBean);
										}
									}
									if(tasteList.size()>0 ){
										//给user2pre表插入
										int addUserPreferenceFood = userOrderService.addUserPreferenceFood(userOrderBean);
									}
							}
						
						}	
					
							responseBean.setStatus(GConstants.STATUS_CODE_2000);
							responseBean.setData("");
							return responseBean;
					
				}
					
					
	//*************************************************第二次订单*******************************************
			  }else{
				  //查询该用户订单状态，1已下单，说明用户下过单还没完结。修改下单状态，订单次数+1
				  UserPreNumEntity userPre =  userOrderService.getStatus(userOrderBean);
				if(userPre.getStatus() == 1){
					
					// 给vip_order表插入
					int userOrderTable = userOrderService.addUserOrderTable(userOrderBean);
					
					//给vip_order_food表插入前获取的orderId
					UserOrderEntity orderIdEntity = userOrderService.getOrderId(userOrderBean);
					if(orderIdEntity!=null){
						userOrderBean.setOrderId(orderIdEntity.getOrderId());
					}
					//给vip_order_food表插入
					int addOrderAndFood = userOrderService.addOrderAndFood(userOrderBean);
					
					// 把订单状态改为已修改，订单次数+1
					int updateOrderStatus = userOrderService.updateOrderStatus(userOrderBean);
					
					//插入vip_orderfood_pre
					List<VipFoodBean> vipFoodList = userOrderBean.getFoodList();
					int classiFy = 0;
					TasteBean tasteBean = new TasteBean ();
					FoodPreBean foodPreBean = new FoodPreBean();
					List<TasteBean> tasteList = new ArrayList<TasteBean>();
					List<FoodPreBean> foodPreList = new ArrayList<FoodPreBean>();
					
					//获取食物状态
					for(VipFoodBean vipFood:vipFoodList){
						classiFy = vipFood.getClassify();
					}
						//单品
						if(classiFy == 0){
							for(VipFoodBean VipFood:vipFoodList){
								if(VipFood!=null){
									tasteList = VipFood.getTasteList();
									if(tasteList!=null){
										for(TasteBean taste:tasteList){
											if(taste!=null){
												userOrderBean.setTasteFoodId(taste.getTasteFoodId());
											}
											
											//获取orderFoodId,为往vip_orderfood_pre表插入
											userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
											if(userPreNumEntity!=null){
												tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
											}
											
											tasteBean.setFoodPreList(taste.getFoodPreList());
											userOrderBean.setRemark(taste.getRemark());
											foodPreList = taste.getFoodPreList();
											if(foodPreList!=null){
												for(FoodPreBean foodPre:foodPreList){
													userOrderBean.setPreId(foodPre.getPreId());
													foodPreBean.setPreName(foodPre.getPreName());
													foodPreBean.setPreId(foodPre.getPreId());
												}
											}
										}
									}
									
								}
								
								if(tasteList!=null ){
									
									//给vip_orderfood_pre表插入
									int foodTaste = userOrderService.addFoodTaste(tasteBean);
									
									//给user2pre表插入
									int addUserPreferenceFood = userOrderService.addUserPreferenceFood(userOrderBean);
								}
							}
							
						//套餐	
						}else if(classiFy == 1){
							
							for(VipFoodBean VipFoodBean:vipFoodList){
								tasteList = VipFoodBean.getTasteList();
								for(TasteBean taste:tasteList){
									userOrderBean.setTasteFoodId(taste.getTasteFoodId());
									userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
									if(userPreNumEntity!=null){
										tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
									}
									
									tasteBean.setFoodPreList(taste.getFoodPreList());
									userOrderBean.setRemark(taste.getRemark());
									foodPreList = taste.getFoodPreList();
									if(foodPreList!=null){
										for(FoodPreBean foodPre:foodPreList){
											userOrderBean.setPreId(foodPre.getPreId());
											foodPreBean.setPreName(foodPre.getPreName());
											foodPreBean.setPreId(foodPre.getPreId());
										}
									}
								}
								if(tasteList.size()>0 ){
									//给vip_orderfood_pre表插入
									int foodTaste = userOrderService.addFoodTaste(tasteBean);
								}
							}
							if(tasteList.size()>0 ){
								//给user2pre表插入
								int addUserPreferenceFood = userOrderService.addUserPreferenceFood(userOrderBean);
							}
				}
				// 否则说明用户已完结状态,直接插入到数据库	
				}else if(userPre.getStatus() == 2){
							
							// 根据昵称查询userId
							UserOrderEntity	userIdEntity = userOrderService.getUserId(userOrderBean);
							userOrderBean.setUserId(userIdEntity.getUserId());
							// 根据座位号查询seatId
							UserOrderEntity seatIdEntity = userOrderService.getSeatId(userOrderBean);
							userOrderBean.setSeatId(seatIdEntity.getSeatId());
							//生成订单唯一标识
							String code = Util.getGenericUUID();
							userOrderBean.setCode(code);
							//查询preNum
							List<UserOrderBean> preNum = userOrderService.getPreNum(userOrderBean);
								for(UserOrderBean userOrderList:preNum){
									if(userOrderList!=null){
										userOrderBean.setPreNum(userOrderList.getPreNum());
									}
								}
			
							//获取orderID，为往vip_order2food表插入
							UserOrderEntity orderIdEntity = userOrderService.getOrderId(userOrderBean);
							if(orderIdEntity!=null){
								userOrderBean.setOrderId(orderIdEntity.getOrderId());
								//给vip_order2food表插入
								int userOrderFood = userOrderService.addUserOrderFood(userOrderBean);
							}
							
							List<VipFoodBean> vipFoodList = userOrderBean.getFoodList();
							
							if(vipFoodList!=null){
								if(userOrderBean.getOrderId()>0){
								int	addOrderAndFood = userOrderService.addOrderAndFood(userOrderBean);
								}
								
								
							}
							
							//如果是单品将食物、口味、偏好插入数据库
							int classiFy = 0;
							TasteBean tasteBean = new TasteBean ();
							FoodPreBean foodPreBean = new FoodPreBean();
							List<TasteBean> tasteList = new ArrayList<TasteBean>();
							List<FoodPreBean> foodPreList = new ArrayList<FoodPreBean>();
							for(VipFoodBean vipFood:vipFoodList){
								classiFy = vipFood.getClassify();
							}
							
								//单品
								if(classiFy == 0){
									for(VipFoodBean VipFood:vipFoodList){
										if(VipFood!=null){
											tasteList = VipFood.getTasteList();
											if(tasteList!=null){
												for(TasteBean taste:tasteList){
													if(taste!=null){
														userOrderBean.setTasteFoodId(taste.getTasteFoodId());
													}
													
													userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
													if(userPreNumEntity!=null){
														tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
													}
													tasteBean.setFoodPreList(taste.getFoodPreList());
													userOrderBean.setRemark(taste.getRemark());
													foodPreList = taste.getFoodPreList();
													if(foodPreList!=null){
														for(FoodPreBean foodPre:foodPreList){
															userOrderBean.setPreId(foodPre.getPreId());
															foodPreBean.setPreName(foodPre.getPreName());
															foodPreBean.setPreId(foodPre.getPreId());
														}
													}
												}
											}
											
										}
										
										if(tasteList!=null ){
											
											//给vip_orderfood_pre表插入
											int foodTaste = userOrderService.addFoodTaste(tasteBean);
											
											//给user2pre表插入
											int addUserPreferenceFood = userOrderService.addUserPreferenceFood(userOrderBean);
										}
									}
								//如果是套餐也将食物、口味、偏好插入数据库	
								}else if(classiFy == 1){
									
									for(VipFoodBean VipFoodBean:vipFoodList){
										tasteList = VipFoodBean.getTasteList();
										for(TasteBean taste:tasteList){
											userOrderBean.setTasteFoodId(taste.getTasteFoodId());
											userPreNumEntity = userOrderService.getOrderFoodId(userOrderBean);
											if(userPreNumEntity!=null){
												tasteBean.setOrderFoodId(userPreNumEntity.getOrderFoodId());
											}
											tasteBean.setFoodPreList(taste.getFoodPreList());
											userOrderBean.setRemark(taste.getRemark());
											foodPreList = taste.getFoodPreList();
											if(foodPreList!=null){
												for(FoodPreBean foodPre:foodPreList){
													userOrderBean.setPreId(foodPre.getPreId());
													foodPreBean.setPreName(foodPre.getPreName());
													foodPreBean.setPreId(foodPre.getPreId());
												}
											}
										}
										if(tasteList.size()>0 ){
											//给vip_orderfood_pre表插入
											int foodTaste = userOrderService.addFoodTaste(tasteBean);
										}
									}
									if(tasteList.size()>0 ){
										//给user2pre表插入
										int addUserPreferenceFood = userOrderService.addUserPreferenceFood(userOrderBean);
									}
							}
				
						}
					
					responseBean.setStatus(GConstants.STATUS_CODE_2000);
					responseBean.setData("");
					return responseBean;
				}
		}else{
			responseBean.setMessage("Order Fail");
			responseBean.setData("");
			responseBean.setStatus(GConstants.STATUS_CODE_4001);
			return responseBean;
		}
		return responseBean;
	}

}
