package com.fos.modules.user.service;


import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Lazy(false)
public class CheckStatusSchedule {
    @Autowired
    private UserService service;

    /**
     * 计划任务
     */
    @Scheduled(cron = "0 */3 * * * ?")
    public void CheckStatus() {
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(Calendar.MINUTE, -30);
        String nowTimeMinusTwo = new SimpleDateFormat("yyyyMMddHHmm").format(nowTime.getTime());
        service.logoutStatus(nowTimeMinusTwo);
    }

}
