package com.fos.modules.user.dao;

import org.apache.ibatis.annotations.Param;

import com.fos.core.base.BaseBean;
import com.fos.core.base.CurdDao;
import com.fos.modules.user.bean.UserBean;
import com.fos.modules.user.entity.UserEntity;

public interface UserDao  extends CurdDao<UserEntity>{

	//登录时验证用户名密码是否正确
	public UserEntity loginUser(UserBean userBean);

	//登录时更新登录状态
	public void updateStatus(UserBean userBean);
	
	//心跳包更新登录状态
	public void checkLoginStatus(@Param(value = "loginName") String loginName, @Param(value = "loginStatus") String loginStatus);
	
	//轮询更新登录状态
	public void logoutStatus(String operationTime);
	
	//心跳包更新登录状态
    public void logout(@Param(value = "loginName") String loginName, @Param(value = "loginStatus") String loginStatus);

}
