package com.fos.modules.user.api;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.base.BaseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.user.bean.UserBean;
import com.fos.modules.user.entity.UserEntity;
import com.fos.modules.user.service.UserService;


@Controller
@RequestMapping(value="/api/user")
public class UserController {

	@Autowired
	private UserService service;
	
	//登录时验证用户名密码是否正确
	@ResponseBody
	@RequestMapping(value="/loginUser")
	public ResponseBean loginUser(RequestBean requestBean){
		
		ResponseBean responseBean = new ResponseBean();
		UserBean userBean = requestBean.getObjectBean(UserBean.class);

		String message=service.validate(userBean);
		if (message==null) {
			
			UserEntity userEntity = service.loginUser(userBean);
			if(userEntity!=null){

				if (null!=userEntity.getLoginType()&&(userEntity.getLoginType().equals("2")||userEntity.getLoginType().equals("3"))){
					boolean ok = service.validatePassword(userBean.getPassword(),userEntity.getPassword());

					if(ok){
					    service.updateStatus(userBean);
						responseBean.setMessage(GConstants.OK);
						responseBean.setStatus(GConstants.STATUS_CODE_2000);
						responseBean.setData(userEntity);
						return responseBean;
					}else{
//						responseBean.setMessage("请输入正确的用户名和密码");
						responseBean.setMessage("Mismatch User Name or Password");
						responseBean.setStatus(GConstants.STATUS_CODE_3001);
						return responseBean;
					}
				}else {
//					responseBean.setMessage("无权限登陆");
					responseBean.setMessage("Mismatch User Name or Password");
					responseBean.setStatus(GConstants.STATUS_CODE_3001);
					return responseBean;
				}

			}else{
				responseBean.setStatus(GConstants.STATUS_CODE_3002);
//				responseBean.setMessage("用户未注册");
				responseBean.setMessage("Mismatch User Name or Password");
				return responseBean;
			}
				
		}
		
		 responseBean.setMessage(message);	
		 responseBean.setStatus(GConstants.STATUS_CODE_4001);
	   
		 return responseBean;
		
	}

	/**
	 * 心跳-更新登录状态
	 * @param requestBean
	 */
    @ResponseBody
    @RequestMapping(value="/checkLoginStatus")
    public ResponseBean checkLoginStatus(RequestBean requestBean){
        ResponseBean responseBean = new ResponseBean();
        BaseBean baseBean = requestBean.getObjectBean(BaseBean.class);
        service.checkLoginStatus(baseBean.getSysName(), "1");
        responseBean.setMessage(GConstants.OK);
        responseBean.setStatus(GConstants.STATUS_CODE_2000);
        responseBean.setData("");
        return responseBean;
    }

    /**
     * 登出接口
     * @param requestBean
     */
    @ResponseBody
    @RequestMapping(value="/logout")
    public ResponseBean logout(RequestBean requestBean){
        ResponseBean responseBean = new ResponseBean();
        BaseBean baseBean = requestBean.getObjectBean(BaseBean.class);
        service.logout(baseBean.getSysName(), "0");
        responseBean.setMessage(GConstants.OK);
        responseBean.setStatus(GConstants.STATUS_CODE_2000);
        responseBean.setData("");
        return responseBean;
    }

}
