package com.fos.modules.unfinishedTable.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;






import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.fos.core.base.CurdService;
import com.fos.core.base.PageEntity;
import com.fos.modules.unfinishedTable.bean.UnfinishedTableBean;
import com.fos.modules.unfinishedTable.dao.NoOrderUserDao;
import com.fos.modules.unfinishedTable.dao.UnfinishedTableDao;
import com.fos.modules.unfinishedTable.dao.UnfinishedTableFoodDao;
import com.fos.modules.unfinishedTable.dao.UnfinishedTableOrderDao;
import com.fos.modules.unfinishedTable.entity.NoOrderUserEntity;
import com.fos.modules.unfinishedTable.entity.UnfinishedTableEntity;
import com.fos.modules.unfinishedTable.entity.UnfinishedTableFoodEntity;
import com.fos.modules.unfinishedTable.entity.UnfinishedTableOrderEntity;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

@Service
public class UnfinishedTableService extends CurdService<UnfinishedTableDao, UnfinishedTableEntity>{
	@Autowired
	private UnfinishedTableDao dao;

	@Autowired
	private UnfinishedTableOrderDao orderDao;

	@Autowired
	private NoOrderUserDao noOrderUserDao;

	@Autowired
	private UnfinishedTableFoodDao foodDao;
	//获取订单未完成的桌号
	public PageEntity<UnfinishedTableEntity> getUnfinishedTableSeatNum(UnfinishedTableBean bean){
		PageHelper.startPage(bean.getPageNo(), bean.getPageSize());
		PageInfo<UnfinishedTableEntity> pageInfo = new PageInfo<UnfinishedTableEntity>(dao.getUnfinishedTableSeatNum(bean));
		if(pageInfo.getPages()<bean.getPageNo()){

			return null;
		}
		//页面中加入订单开始
		for(int i=0;i<pageInfo.getList().size();i++){
			List<NoOrderUserEntity> noOrderUserNames = noOrderUserDao.getNoOrdeUser(pageInfo.getList().get(i));
			List<UnfinishedTableOrderEntity> tableOrders = orderDao.getUnfinishedTableOrder(pageInfo.getList().get(i));
			if(tableOrders!=null&&tableOrders.size()>0){
			//页面中加入食品开始
			for(UnfinishedTableOrderEntity order : tableOrders){
				List<UnfinishedTableFoodEntity> foodEntityList = new ArrayList<UnfinishedTableFoodEntity>();
				List<UnfinishedTableFoodEntity> foodEntities = foodDao.getUnfinishedTableFood(order.getOrderId());
				//获取所有食品名称
				for(UnfinishedTableFoodEntity foodEntity : foodEntities){
					if(!foodEntityList.contains(foodEntity)){
						foodEntityList.add(foodEntity);
					}
				}
				order.setFoods(foodEntityList);
				
			}
			//页面中加入食品结束
			pageInfo.getList().get(i).setCreateTime(tableOrders.get(0).getCreateTime());
			pageInfo.getList().get(i).setOrder(tableOrders);
			}
			pageInfo.getList().get(i).setNoOrderUser(noOrderUserNames);
		}
		//页面中加入订单结束
		PageEntity<UnfinishedTableEntity> page = new PageEntity<UnfinishedTableEntity>();
		page.setPageNo(pageInfo.getPageNum());
		page.setPageSize(pageInfo.getPageSize());
		page.setCount(pageInfo.getTotal());
		page.setTotalPage(pageInfo.getPages());
		page.setList(pageInfo.getList());
		return page;
	}

}
	
