package com.fos.modules.unfinishedTable.api;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.base.PageEntity;
import com.fos.core.conf.GConstants;
import com.fos.modules.unfinishedTable.bean.UnfinishedTableBean;
import com.fos.modules.unfinishedTable.entity.UnfinishedTableEntity;
import com.fos.modules.unfinishedTable.service.UnfinishedTableService;


@Controller
@RequestMapping(value = "/api/unfinishedTableController")
public class UnfinishedTableController {
	
	@Autowired
	private UnfinishedTableService unfinishedTableService;
	 	@ResponseBody
	    @RequestMapping(value = "/getUnfinishedTableSeatNum")
	    public ResponseBean getAllUnfinishedTable(RequestBean requestBean) {
	        ResponseBean responseBean = new ResponseBean();
	        UnfinishedTableBean bean = requestBean.getObjectBean(UnfinishedTableBean.class);
	        String message = unfinishedTableService.validate(bean);
	        if (message == null) {
	            PageEntity<UnfinishedTableEntity> unfinishedTableEntities = unfinishedTableService.getUnfinishedTableSeatNum(bean);
		        if (unfinishedTableEntities!=null) {
			        if (unfinishedTableEntities.getPageSize() > 0) {
				        responseBean.setMessage(GConstants.OK);
				        responseBean.setStatus(GConstants.STATUS_CODE_2000);
				        responseBean.setData(unfinishedTableEntities);
				        return responseBean;
			        } else {
				        responseBean.setMessage("No seat number");
				        responseBean.setStatus(GConstants.STATUS_CODE_2001);
				        return responseBean;
			        }
		        }else {
			        responseBean.setMessage("No seat number");
			        responseBean.setStatus(GConstants.STATUS_CODE_2001);
			        return responseBean;
		        }
	        }
	        responseBean.setMessage(message);
	        responseBean.setStatus(GConstants.STATUS_CODE_4001);
	        return responseBean;
	    }

	/*@ResponseBody
	@RequestMapping(value = "/getUnfinishedTableNickName")
	public ResponseBean getUnfinishedTableNickName(RequestBean requestBean) {
	    ResponseBean responseBean = new ResponseBean();
	    UnfinishedTableBean bean = requestBean.getObjectBean(UnfinishedTableBean.class);
	    String message = UnfinishedTableService.validate(bean);
	    if (message == null) {
	        List<UnfinishedTableEntity> UnfinishedTableEntities = UnfinishedTableService.getUnfinishedTableNickName();
	        if (UnfinishedTableEntities.size() > 0) {
	            responseBean.setMessage(GConstants.OK);
	            responseBean.setStatus(GConstants.STATUS_CODE_2000);
	            responseBean.setData(UnfinishedTableEntities);
	            return responseBean;
	        } else {
	            responseBean.setMessage("本日无订单");
	            responseBean.setStatus(GConstants.STATUS_CODE_2001);
	            return responseBean;
	        }
	    }
	    responseBean.setMessage(message);
	    responseBean.setStatus(GConstants.STATUS_CODE_4001);
	    return responseBean;
	}
	@ResponseBody
	@RequestMapping(value = "/getUnfinishedTableStartTime")
	public ResponseBean getUnfinishedTableStartTime(RequestBean requestBean) {
	    ResponseBean responseBean = new ResponseBean();
	    UnfinishedTableBean bean = requestBean.getObjectBean(UnfinishedTableBean.class);
	    String message = UnfinishedTableService.validate(bean);
	    if (message == null) {
	        List<UnfinishedTableEntity> UnfinishedTableEntities = UnfinishedTableService.getUnfinishedTableStartTime();
	        if (UnfinishedTableEntities.size() > 0) {
	            responseBean.setMessage(GConstants.OK);
	            responseBean.setStatus(GConstants.STATUS_CODE_2000);
	            responseBean.setData(UnfinishedTableEntities);
	            return responseBean;
	        } else {
	            responseBean.setMessage("本日无订单");
	            responseBean.setStatus(GConstants.STATUS_CODE_2001);
	            return responseBean;
	        }
	    }
	    responseBean.setMessage(message);
	    responseBean.setStatus(GConstants.STATUS_CODE_4001);
	    return responseBean;
	}
	@ResponseBody
	@RequestMapping(value = "/getUnfinishedTableEndTime")
	public ResponseBean getUnfinishedTableEndTime(RequestBean requestBean) {
	    ResponseBean responseBean = new ResponseBean();
	    UnfinishedTableBean bean = requestBean.getObjectBean(UnfinishedTableBean.class);
	    String message = UnfinishedTableService.validate(bean);
	    if (message == null) {
	        List<UnfinishedTableEntity> UnfinishedTableEntities = UnfinishedTableService.getUnfinishedTableEndTime();
	        if (UnfinishedTableEntities.size() > 0) {
	            responseBean.setMessage(GConstants.OK);
	            responseBean.setStatus(GConstants.STATUS_CODE_2000);
	            responseBean.setData(UnfinishedTableEntities);
	            return responseBean;
	        } else {
	            responseBean.setMessage("本日无订单");
	            responseBean.setStatus(GConstants.STATUS_CODE_2001);
	            return responseBean;
	        }
	    }
	    responseBean.setMessage(message);
	    responseBean.setStatus(GConstants.STATUS_CODE_4001);
	    return responseBean;
	}*/
}
	