package com.fos.modules.todayOverTable.service;

import java.util.ArrayList;

import java.util.List;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.fos.core.base.CurdService;
import com.fos.core.base.PageEntity;

import com.fos.modules.todayOverTable.bean.TodayOverTableBean;
import com.fos.modules.todayOverTable.dao.TodayOverTableDao;
import com.fos.modules.todayOverTable.dao.TodayOverTableFoodDao;
import com.fos.modules.todayOverTable.dao.TodayOverTableOrderDao;
import com.fos.modules.todayOverTable.entity.TodayOverTableEntity;
import com.fos.modules.todayOverTable.entity.TodayOverTableFoodEntity;
import com.fos.modules.todayOverTable.entity.TodayOverTableOrderEntity;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

@Service
public class TodayOverTableService extends CurdService<TodayOverTableDao, TodayOverTableEntity>{
	@Autowired
	private TodayOverTableDao dao;
	
	@Autowired
	private TodayOverTableOrderDao orderDao;
	
	@Autowired
	private TodayOverTableFoodDao foodDao;
	//获取今天订单已结束的桌号
	/*public PageEntity<TodayOverTableEntity> getTodayOverTableSeatNum(TodayOverTableBean bean){
		PageHelper.startPage(bean.getPageNo(), bean.getPageSize());
		List<TodayOverTableEntity> seatnum=dao.getTodayOverTableSeatNum(bean);
		PageInfo<TodayOverTableEntity> pageInfo = new PageInfo<TodayOverTableEntity>(seatnum);
		if(pageInfo.getPages()<bean.getPageNo()){
            return null;
        }
		//页面中加入订单开始
		for(int i=0;i<pageInfo.getList().size();i++){

			List<TodayOverTableOrderEntity> tableOrders = orderDao.getTodayOverTableOrder(pageInfo.getList().get(i).getSeatNum());
			
			List<TodayOverTableEntity> startTime = dao.getTodayOverTableStartTime(pageInfo.getList().get(i).getSeatNum());
			List<TodayOverTableEntity> endTime = dao.getTodayOverTableEndTime(pageInfo.getList().get(i).getSeatNum());
			pageInfo.getList().get(i).setCreateTime(startTime.get(0).getCreateTime());
			pageInfo.getList().get(i).setEndTime(endTime.get(0).getEndTime());
			//页面中加入食品开始
			for(TodayOverTableOrderEntity order : tableOrders){
				
			List<TodayOverTableFoodEntity> foodEntityList = new ArrayList<TodayOverTableFoodEntity>();
			List<TodayOverTableFoodEntity> foodEntities = foodDao.getTodayOverTableFood(order.getOrderId());
			//获取所有食品名称
			for(TodayOverTableFoodEntity foodEntity : foodEntities){
				if(!foodEntityList.contains(foodEntity)){
					foodEntityList.add(foodEntity);
				}
			}
			order.setFoods(foodEntityList);
			}
			//页面中加入食品结束
			pageInfo.getList().get(i).setOrder(tableOrders);
		}
	    PageEntity<TodayOverTableEntity> page = new PageEntity<TodayOverTableEntity>();
	    page.setPageNo(pageInfo.getPageNum());
	    page.setPageSize(pageInfo.getPageSize());
	    page.setCount(pageInfo.getTotal());
	    page.setTotalPage(pageInfo.getPages());
	    page.setList(pageInfo.getList());
	    return page;
	}
	*/
	
	//sortType=="other"或"table"
	public PageEntity<TodayOverTableOrderEntity> getTodayOverTableOrder(TodayOverTableBean bean){
		PageHelper.startPage(bean.getPageNo(), bean.getPageSize());
		List<TodayOverTableOrderEntity> orders;
		
			orders=orderDao.getTodayOverTableOrder(bean);
			PageInfo<TodayOverTableOrderEntity> pageInfo = new PageInfo<TodayOverTableOrderEntity>(orders);
		if(pageInfo.getPages()<bean.getPageNo()){
            return null;
        }
		//页面中加入订单开始
		for(int i=0;i<pageInfo.getList().size();i++){
			List<TodayOverTableFoodEntity> foodEntities = foodDao.getTodayOverTableFood(pageInfo.getList().get(i).getOrderId());
			pageInfo.getList().get(i).setFoods(foodEntities);
		}
		
		
	    PageEntity<TodayOverTableOrderEntity> page = new PageEntity<TodayOverTableOrderEntity>();
	    page.setPageNo(pageInfo.getPageNum());
	    page.setPageSize(pageInfo.getPageSize());
	    page.setCount(pageInfo.getTotal());
	    page.setTotalPage(pageInfo.getPages());
	    page.setList(pageInfo.getList());
	    return page;
	}
}
	
