package com.fos.modules.todayOverTable.bean;

import javax.validation.constraints.Min;

import com.alibaba.fastjson.annotation.JSONField;
import com.fos.core.base.BaseBean;
import com.fos.core.conf.GConstants;

public class TodayOverTableBean extends BaseBean{
	@Min(value=1, message="page_no必须大于等于1")
    @JSONField(name="page_no")
    private int pageNo=1;//第几页
    
    @Min(value=1, message="page_size必须大于等于1")
    @JSONField(name="page_size")
    private int pageSize=8;//每页条数
    
    @JSONField(name="SortType")
    private String SortType;//排序条件
    
    /*
     * SortType='seatnum' 以座号排序
     * SortType='other'或 SortType=null 默认排序
     */
	public String getSortType() {
		return SortType;
	}

	public void setSortType(String sortType) {
		SortType = sortType;
	}
	

	public int getPageNo() {
		return pageNo;
	}

	public void setPageNo(int pageNo) {
		this.pageNo = pageNo;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
    
}
