package com.fos.modules.todayOverTable.api;

import java.util.List;

import com.fos.modules.orderView.entity.Page;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.base.PageEntity;
import com.fos.core.conf.GConstants;
import com.fos.modules.todayOverTable.bean.TodayOverTableBean;
import com.fos.modules.todayOverTable.entity.TodayOverTableEntity;
import com.fos.modules.todayOverTable.entity.TodayOverTableOrderEntity;
import com.fos.modules.todayOverTable.service.TodayOverTableService;

@Controller
@RequestMapping(value = "/api/todayOverTableController")
public class TodayOverTableController {

	@Autowired
	private TodayOverTableService todayOverTableService;

	@ResponseBody
	@RequestMapping(value = "/getTodayOverTableSeatNum")
	public ResponseBean getAllTodayOverTable(RequestBean requestBean) {
		ResponseBean responseBean = new ResponseBean();
		TodayOverTableBean bean = requestBean
				.getObjectBean(TodayOverTableBean.class);
		String message = todayOverTableService.validate(bean);
		if (message == null) {
			//PageEntity<TodayOverTableEntity> todayOverTableEntities;
			PageEntity<TodayOverTableOrderEntity> todayOverTableOrderEntities;
			//sortType="other"时
			/*if (bean.getSortType().equals("other")) {
				todayOverTableOrderEntities = todayOverTableService
						.getTodayOverTableOrder(bean);
				if (todayOverTableOrderEntities != null) {
					if (todayOverTableOrderEntities.getPageSize() > 0) {
						responseBean.setMessage(GConstants.OK);
						responseBean.setStatus(GConstants.STATUS_CODE_2000);
						responseBean.setData(todayOverTableOrderEntities);
						return responseBean;
					} else {
						responseBean.setMessage("no seat number");
						responseBean.setStatus(GConstants.STATUS_CODE_2001);
						return responseBean;
					}
				} else {
					responseBean.setMessage("no record");
					responseBean.setStatus(GConstants.STATUS_CODE_2001);
					return responseBean;
				}
			} else {*/
				//sortType=其他时
				/*todayOverTableEntities = todayOverTableService
						.getTodayOverTableSeatNum(bean);
				if (todayOverTableEntities != null) {
					if (todayOverTableEntities.getPageSize() > 0) {
						responseBean.setMessage(GConstants.OK);
						responseBean.setStatus(GConstants.STATUS_CODE_2000);
						responseBean.setData(todayOverTableEntities);*/
				//修改结构
				todayOverTableOrderEntities = todayOverTableService
						.getTodayOverTableOrder(bean);
				if (todayOverTableOrderEntities != null) {
					if (todayOverTableOrderEntities.getPageSize() > 0) {
						responseBean.setMessage(GConstants.OK);
						responseBean.setStatus(GConstants.STATUS_CODE_2000);
						responseBean.setData(todayOverTableOrderEntities);
						return responseBean;
					} else {
						responseBean.setMessage("No seat number");
						responseBean.setStatus(GConstants.STATUS_CODE_2001);
						return responseBean;
					}
				} else {
					responseBean.setMessage("No record");
					responseBean.setStatus(GConstants.STATUS_CODE_2001);
					return responseBean;
				}
			//}
		}
		responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_4001);
		return responseBean;
	}

}
