package com.fos.modules.tableView.service;

import com.fos.core.base.CurdService;
import com.fos.modules.tableOrder.bean.TableOrderCodeBean;
import com.fos.modules.tableOrder.entity.TableOrderFoodConEntity;
import com.fos.modules.tableOrder.service.TableOrderFoodService;
import com.fos.modules.tableView.dao.TableViewDao;
import com.fos.modules.tableView.entity.TableTimeEntity;
import com.fos.modules.tableView.entity.TableViewEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Tony on 8/4/2016.
 */
@Service
public class TableViewService extends CurdService<TableViewDao, TableViewEntity> {

    @Autowired
    private TableOrderFoodService foodService;

    public List<TableViewEntity> getAllTable(TableTimeEntity entity) {
        List<TableViewEntity> tableViewEntities = new ArrayList<TableViewEntity>();
        List<TableViewEntity> viewEntities = dao.getAllTable();
        //获取所有桌号
        List<String> seatNums = new ArrayList<String>();
        for (TableViewEntity viewEntity : viewEntities) {
            if (!seatNums.contains(viewEntity.getTableArea() +viewEntity.getSeatNum())) {
                seatNums.add(viewEntity.getTableArea() +viewEntity.getSeatNum());
            }
        }
        //根据桌号验证是否有延迟上菜
        for (String seat : seatNums) {
            boolean flag = false;//延迟上菜
            TableViewEntity tableViewEntity = new TableViewEntity();
            boolean seatFlag = true;//是否全部下单
            int count = 0;
            for (TableViewEntity viewEntity : viewEntities) {
                if (seat.equals(viewEntity.getTableArea()+viewEntity.getSeatNum())) {
                    if (viewEntity.getCode() != null && !"".equals(viewEntity.getCode())) {
                        count++;
                        if (count != viewEntity.getUserCount()) {
                            seatFlag = false;
                        } else {
                            seatFlag = true;
                        }
                    } else {
                        seatFlag = false;
                    }
                    if (viewEntity.getUserCount() == 0) {
                        tableViewEntity.setColor(1);
                    } else if (0 < viewEntity.getUserCount() && viewEntity.getUserCount() != viewEntity.getMaxNum()) {
                        tableViewEntity.setColor(2);
                    } else if (viewEntity.getUserCount() == viewEntity.getMaxNum()) {
                        tableViewEntity.setColor(3);
                    } else {
                        tableViewEntity.setColor(1);
                    }
                    if (viewEntity.getCode() != null && !"".equals(viewEntity.getCode())) {
                        TableOrderCodeBean codeBean = new TableOrderCodeBean();
                        codeBean.setCode(viewEntity.getCode());
                        List<TableOrderFoodConEntity> foodConEntityList = foodService.getTableOrderFood(codeBean);
                        if(viewEntity.getUserCount() == 0){
                        	flag = false;
                        }else{
                        	for (TableOrderFoodConEntity conEntity : foodConEntityList) {
                                if (conEntity.getArriveTime() == null) {
                                    if (conEntity.getBeginTime() != null) {
                                        Long diff = (System.currentTimeMillis() - conEntity.getBeginTime().getTime()) / (1000 * 60);
                                        if (diff > entity.getEndTime()) {
                                            flag = true;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    tableViewEntity.setRowNum(viewEntity.getRowNum());
                    tableViewEntity.setColNum(viewEntity.getColNum());
                    tableViewEntity.setFlag(flag);
                    tableViewEntity.setSeatNum(viewEntity.getSeatNum());
                    tableViewEntity.setUserCount(viewEntity.getUserCount());
                    tableViewEntity.setCode(viewEntity.getCode());
                    tableViewEntity.setMaxNum(viewEntity.getMaxNum());
                    tableViewEntity.setOrderStatus(seatFlag);
                    tableViewEntity.setTableArea(viewEntity.getTableArea());
                }
            }
            tableViewEntities.add(tableViewEntity);
        }
        return tableViewEntities;
    }
}
