package com.fos.modules.tableView.service;

import com.fos.core.base.CurdService;
import com.fos.modules.myUserPre.bean.MyUserPreBean;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkEntity;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkTasteEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodTasteEntity;
import com.fos.modules.myUserPre.service.MyUserPreService;
import com.fos.modules.tableView.dao.TableViewFoodDao;
import com.fos.modules.tableView.dao.TableViewOrderDao;
import com.fos.modules.tableView.dao.TableViewPreDao;
import com.fos.modules.tableView.entity.TableViewFoodEntity;
import com.fos.modules.tableView.entity.TableViewNumEntity;
import com.fos.modules.tableView.entity.TableViewOrderEntity;
import com.fos.modules.tableView.entity.TableViewPreEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Tony on 2016/10/12.
 */
@Service
public class TableViewOrderService extends CurdService<TableViewOrderDao, TableViewOrderEntity> {

    @Autowired
    private TableViewFoodDao foodDao;

    @Autowired
    private TableViewPreDao preDao;

    @Autowired
    private MyUserPreService myUserPreService;

    public List<TableViewOrderEntity> getOrderList(TableViewNumEntity bean) {
        List<TableViewOrderEntity> allOrder = new ArrayList<TableViewOrderEntity>();
        List<TableViewOrderEntity> noOrder = new ArrayList<TableViewOrderEntity>();
        noOrder = dao.getNoOrderList(bean);
        MyUserPreBean preBean = new MyUserPreBean();
        for (TableViewOrderEntity order : noOrder) {
            preBean.setNickName(order.getNickName());
            List<MyUserPreFoodEntity> myUserPreFoodList = myUserPreService.getMyUserPreFood(preBean);
            //获取该用户前3喜欢的食物口味
            List<MyUserPreFoodTasteEntity> myUserPreFoodTasteList = myUserPreService.getMyUserPreFoodTaste(preBean);
            //获取该用户前3喜欢的喝的
            List<MyUserPreDrinkEntity> myUserPreDrinkList = myUserPreService.getMyUserPreDrink(preBean);
            //获取该用户前3喜欢的喝的口味
            List<MyUserPreDrinkTasteEntity> myUserPreDrinkTasteList = myUserPreService.getMyUserPreDrinkTaste(preBean);
            order.setUserPreFoodList(myUserPreFoodList);
            order.setUserPreFoodTasteList(myUserPreFoodTasteList);
            order.setUserPreDrinkList(myUserPreDrinkList);
            order.setUserPreDrinkTasteList(myUserPreDrinkTasteList);
            order.setOrderStatus(0);
            order.setCheckOutStatus(0);
            order.setOrderNum(0);
            //order.setLoginCount("0");
            allOrder.add(order);
        }
        List<TableViewOrderEntity> hasOrder = new ArrayList<TableViewOrderEntity>();
        hasOrder = dao.getOrderList(bean);
        for (TableViewOrderEntity order : hasOrder) {
            preBean.setNickName(order.getNickName());
            List<MyUserPreFoodEntity> myUserPreFoodList = myUserPreService.getMyUserPreFood(preBean);
            //获取该用户前3喜欢的食物口味
            List<MyUserPreFoodTasteEntity> myUserPreFoodTasteList = myUserPreService.getMyUserPreFoodTaste(preBean);
            //获取该用户前3喜欢的喝的
            List<MyUserPreDrinkEntity> myUserPreDrinkList = myUserPreService.getMyUserPreDrink(preBean);
            //获取该用户前3喜欢的喝的口味
            List<MyUserPreDrinkTasteEntity> myUserPreDrinkTasteList = myUserPreService.getMyUserPreDrinkTaste(preBean);
            order.setUserPreFoodList(myUserPreFoodList);
            order.setUserPreFoodTasteList(myUserPreFoodTasteList);
            order.setUserPreDrinkList(myUserPreDrinkList);
            order.setUserPreDrinkTasteList(myUserPreDrinkTasteList);

            if (order.getOrderStatus() == 0 || order.getOrderStatus() == 1) {
                order.setOrderStatus(1);
                order.setCheckOutStatus(0);
            } else {
                order.setOrderStatus(2);
                order.setCheckOutStatus(1);
            }
            allOrder.add(order);
        }
        for (TableViewOrderEntity order : allOrder) {
            if (order.getOrderId() != 0) {
                List<TableViewFoodEntity> foodList = foodDao.getFoodInfo(order);
                for (TableViewFoodEntity food : foodList) {
                    List<TableViewPreEntity> preList = preDao.getPreInfo(food);
                    if (preList.size() > 0) {
                        food.setPreList(preList);
                    } else {
                        preList = new ArrayList<TableViewPreEntity>();
                        food.setPreList(preList);
                    }
                }
                List<TableViewFoodEntity> nFoodList = new ArrayList<TableViewFoodEntity>();
                for (int i = 0; i < foodList.size(); i++) {
                    if (i == 0) {
                        nFoodList.add(foodList.get(i));
                    } else {
                        boolean flag = true;
                        TableViewFoodEntity foodEntity = new TableViewFoodEntity();
                        for (int j = 0; j < nFoodList.size(); j++) {
                            if (foodList.get(i).getFoodId() == nFoodList.get(j).getFoodId()) {
                                boolean preflag = false;
                                if (foodList.get(i).getPreList().size() != 0 && nFoodList.get(j).getPreList().size() != 0) {
                                    for (TableViewPreEntity pre : foodList.get(i).getPreList()) {
                                        for (TableViewPreEntity npre : nFoodList.get(j).getPreList()) {
                                            if (pre.getPreName().equals(npre.getPreName())) {
                                                preflag = true;
                                                break;
                                            } else {
                                                preflag = false;
                                            }
                                        }
                                        if (preflag) {
                                            preflag = true;
                                        } else {
                                            preflag = false;
                                            break;
                                        }
                                    }
                                } else {
                                    preflag = true;
                                }
                                if (preflag) {
                                    int num = Integer.parseInt(foodList.get(i).getFoodNum()) + Integer.parseInt(nFoodList.get(j).getFoodNum());
                                    nFoodList.get(j).setFoodNum(String.valueOf(num));
                                    flag = true;
                                    break;
                                } else {
                                    flag = false;
                                    foodEntity = foodList.get(i);
                                }
                            } else {
                                flag = false;
                                foodEntity = foodList.get(i);
//                                nFoodList.add(foodList.get(i));
//                                break;
                            }
                        }
                        if (!flag) {
                            nFoodList.add(foodEntity);
                        }

                    }
                }
                order.setFoodList(nFoodList);
            }
        }
        return allOrder;
    }

    ;
}
