package com.fos.modules.tableView.service;

import com.fos.core.base.CurdService;
import com.fos.modules.tableView.bean.Table2UserNameBean;
import com.fos.modules.tableView.dao.Table2UserDao;
import com.fos.modules.tableView.entity.Table2UserEntity;
import com.fos.modules.tableView.entity.TableUserInfoEntity;
import com.fos.modules.tableView.entity.TableViewEntity;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Tony on 8/4/2016.
 */
@Service
public class Table2UserService extends CurdService<Table2UserDao, Table2UserEntity> {

    public List<Integer> getUserId(Table2UserNameBean bean) {
        return dao.getUserId(bean);
    }

    //编辑用户-座位关系
    public void insertTableUser(Table2UserEntity entity) {
        dao.insertTableUser(entity);
    }

    //修改用户-座位关系
    public void updateTableUser(Table2UserEntity entity) {
        dao.updateTableUser(entity);
    }

    //删除用户-座位关系
    public void delTableUser(Table2UserEntity entity) {
        dao.delTableUser(entity);
    }

    public Integer getSeatId(Table2UserNameBean bean) {
        return dao.getSeatId(bean);
    }

    public void updateSeatStatus(Table2UserEntity entity) {
        dao.updateSeatStatus(entity);
    }

    public void updateSeatNoStatus(Table2UserEntity entity) {
        dao.updateSeatNotatus(entity);
    }

    public TableViewEntity getCurrentUser(Table2UserEntity entity) {
        List<TableViewEntity> list = dao.getCurrentUser(entity);
        TableViewEntity viewEntity = new TableViewEntity();
        viewEntity = list.get(0);
        return viewEntity;
    }

    //验证用户-座位关系
    public List<TableUserInfoEntity> checkTableUser(Table2UserEntity entity) {
        return dao.checkTableUser(entity);
    }
}
