package com.fos.modules.tableView.api;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.tableView.bean.TableNumBean;
import com.fos.modules.tableView.bean.TableViewBean;
import com.fos.modules.tableView.bean.TableViewBySeatNoBean;
import com.fos.modules.tableView.entity.*;
import com.fos.modules.tableView.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * Created by Tony on 8/4/2016.
 */
@Controller
@RequestMapping(value = "/api/tableView")
public class TableViewController {

    @Autowired
    private TableViewService tableViewService;
    @Autowired
    private TableTimeService tableTimeService;
    @Autowired
    private TableNumService tableNumService;
    @Autowired
    private TableViewNumService viewNumService;
    @Autowired
    private TableViewOrderService viewOrderService;

    @ResponseBody
    @RequestMapping(value = "/getTableOrder")
    public ResponseBean getAllTable(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableViewBean bean = requestBean.getObjectBean(TableViewBean.class);
        String message = tableViewService.validate(bean);
        if (message == null) {
            TableTimeEntity timeEntity = tableTimeService.getTableTime();
            if (timeEntity != null) {
                List<TableViewEntity> tableViewEntities = tableViewService.getAllTable(timeEntity);
                if (tableViewEntities.size() > 0) {
                    responseBean.setMessage(GConstants.OK);
                    responseBean.setStatus(GConstants.STATUS_CODE_2000);
                    responseBean.setData(tableViewEntities);
                    return responseBean;
                } else {
                    responseBean.setStatus(GConstants.STATUS_CODE_2001);
                    responseBean.setMessage("No seat info");
                    return responseBean;
                }
            } else {
                responseBean.setMessage(message);
                responseBean.setStatus(GConstants.STATUS_CODE_4001);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/getAllTableNum")
    public ResponseBean getAllTableNum(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableNumBean bean = requestBean.getObjectBean(TableNumBean.class);
        String message = tableNumService.validate(bean);
        if (message == null) {
            List<TableNumEntity> tableNumEntities = tableNumService.getAllTableNum();
            if (tableNumEntities.size() > 0) {
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                responseBean.setData(tableNumEntities);
                return responseBean;
            } else {
                responseBean.setMessage("No seat info");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }


    @ResponseBody
    @RequestMapping(value = "/getTableView")
    public ResponseBean getTableView(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableViewBySeatNoBean bean = requestBean.getObjectBean(TableViewBySeatNoBean.class);
        String message = viewNumService.validate(bean);
        if (message == null) {
            TableViewNumEntity tableInfo = viewNumService.getTableInfo(bean);
            List<TableViewOrderEntity> orderList = viewOrderService.getOrderList(tableInfo);
            tableInfo.setOrderList(orderList);
            responseBean.setMessage(GConstants.OK);
            responseBean.setStatus(GConstants.STATUS_CODE_2000);
            responseBean.setData(tableInfo);
            return responseBean;
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }
}
