package com.fos.modules.tableView.api;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.tableView.bean.Table2UserBean;
import com.fos.modules.tableView.bean.Table2UserNameBean;
import com.fos.modules.tableView.entity.Table2UserEntity;
import com.fos.modules.tableView.entity.TableUserInfoEntity;
import com.fos.modules.tableView.entity.TableViewEntity;
import com.fos.modules.tableView.service.Table2UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Tony on 8/4/2016.
 */
@Controller
@RequestMapping(value = "/api/table2User")
public class Table2UserController {

    @Autowired
    private Table2UserService userService;


    @ResponseBody
    @RequestMapping(value = "/layUserTable")
    public ResponseBean layUserTable(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        Table2UserBean bean = requestBean.getObjectBean(Table2UserBean.class);
        String message = userService.validate(bean);
        if (message == null) {
            boolean flag = true;
            boolean seatFlag = false;
            List<TableUserInfoEntity> infoEntities = new ArrayList<TableUserInfoEntity>();
            for (Table2UserNameBean nameBean : bean.getTableUser()) {
                Table2UserEntity userEntity = new Table2UserEntity();
                userEntity.setUserId(userService.getUserId(nameBean));
                userEntity.setSeatId(userService.getSeatId(nameBean));
                infoEntities = userService.checkTableUser(userEntity);
                if (infoEntities.size() > 0) {
                    seatFlag = true;
                    break;
                }
                int diff = 0;
                TableViewEntity viewEntity = userService.getCurrentUser(userEntity);
                diff = viewEntity.getMaxNum() - viewEntity.getUserCount();
                if (diff < nameBean.getNickNames().size()) {
                    flag = false;
                    break;
                }
                userService.insertTableUser(userEntity);
                userService.updateSeatStatus(userEntity);
                userService.updateTableUser(userEntity);
            }
            if (seatFlag) {
                responseBean.setData(infoEntities);
                responseBean.setMessage("Customer already seated");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            } else {
                if (flag) {
                    responseBean.setMessage(GConstants.OK);
                    responseBean.setStatus(GConstants.STATUS_CODE_2000);
                    return responseBean;
                } else {
                    responseBean.setMessage("Table full");
                    responseBean.setStatus(GConstants.STATUS_CODE_2001);
                    return responseBean;
                }
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }


    @ResponseBody
    @RequestMapping(value = "/layOutUserTable")
    public ResponseBean layOutUserTable(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        Table2UserBean bean = requestBean.getObjectBean(Table2UserBean.class);
        String message = userService.validate(bean);
        if (message == null) {
            for (Table2UserNameBean nameBean : bean.getTableUser()) {
                Table2UserEntity userEntity = new Table2UserEntity();
                userEntity.setUserId(userService.getUserId(nameBean));
                //userEntity.setSeatId(userService.getSeatId(nameBean));
                userService.delTableUser(userEntity);
                userService.updateSeatNoStatus(userEntity);
            }
            responseBean.setMessage(GConstants.OK);
            responseBean.setStatus(GConstants.STATUS_CODE_2000);
            return responseBean;
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/changeUserTable")
    public ResponseBean changeUserTable(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        Table2UserBean bean = requestBean.getObjectBean(Table2UserBean.class);
        String message = userService.validate(bean);
        if (message == null) {
            boolean flag = true;
            boolean seatFlag = false;
            List<TableUserInfoEntity> infoEntities = new ArrayList<TableUserInfoEntity>();
            for (Table2UserNameBean nameBean : bean.getTableUser()) {
                Table2UserEntity userEntity = new Table2UserEntity();
                userEntity.setUserId(userService.getUserId(nameBean));
                userEntity.setSeatId(userService.getSeatId(nameBean));
                infoEntities = userService.checkTableUser(userEntity);
                if (infoEntities.size() > 0) {
                    seatFlag = true;
                    break;
                }
                int diff = 0;
                TableViewEntity viewEntity = userService.getCurrentUser(userEntity);
                diff = viewEntity.getMaxNum() - viewEntity.getUserCount();
                if (diff < nameBean.getNickNames().size()) {
                    flag = false;
                    break;
                }
                userService.delTableUser(userEntity);
                userService.updateSeatNoStatus(userEntity);

                userService.insertTableUser(userEntity);
                userService.updateSeatStatus(userEntity);
                userService.updateTableUser(userEntity);
            }
            if (seatFlag) {
                responseBean.setData(infoEntities);
                responseBean.setMessage("Customer already seated");
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                return responseBean;
            } else {
                if (flag) {
                    responseBean.setMessage(GConstants.OK);
                    responseBean.setStatus(GConstants.STATUS_CODE_2000);
                    return responseBean;
                } else {
                    responseBean.setMessage("Table full");
                    responseBean.setStatus(GConstants.STATUS_CODE_2001);
                    return responseBean;
                }
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }


}
