package com.fos.modules.tableOrder.service;

import com.fos.core.base.CurdService;
import com.fos.modules.myUserPre.bean.MyUserPreBean;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkEntity;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkTasteEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodTasteEntity;
import com.fos.modules.myUserPre.service.MyUserPreService;
import com.fos.modules.tableOrder.bean.TableOrderBean;
import com.fos.modules.tableOrder.dao.TableUserDao;
import com.fos.modules.tableOrder.entity.TableUserEntity;
import com.fos.modules.vipuser.entity.VipUserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Tony on 8/1/2016.
 */
@Service
public class TableUserService extends CurdService<TableUserDao, TableUserEntity> {

    @Autowired
    private MyUserPreService myUserPreService;

    public List<TableUserEntity> getTableUser(TableOrderBean bean) {
        List<TableUserEntity> users = new ArrayList<TableUserEntity>();
        users = dao.getTableUser(bean);
        MyUserPreBean preBean = new MyUserPreBean();
        for (TableUserEntity user : users) {
            preBean.setNickName(user.getNickName());
            // 获取该用户前3喜欢的食物
            List<MyUserPreFoodEntity> myUserPreFoodList = myUserPreService.getMyUserPreFood(preBean);
            //获取该用户前3喜欢的食物口味
            List<MyUserPreFoodTasteEntity> myUserPreFoodTasteList = myUserPreService.getMyUserPreFoodTaste(preBean);
            //获取该用户前3喜欢的喝的
            List<MyUserPreDrinkEntity> myUserPreDrinkList = myUserPreService.getMyUserPreDrink(preBean);
            //获取该用户前3喜欢的喝的口味
            List<MyUserPreDrinkTasteEntity> myUserPreDrinkTasteList = myUserPreService.getMyUserPreDrinkTaste(preBean);
            user.setUserPreFoodList(myUserPreFoodList);
            user.setUserPreFoodTasteList(myUserPreFoodTasteList);
            user.setUserPreDrinkList(myUserPreDrinkList);
            user.setUserPreDrinkTasteList(myUserPreDrinkTasteList);
        }
        return users;
    }
}
