package com.fos.modules.tableOrder.service;

import com.fos.core.base.CurdService;
import com.fos.modules.tableOrder.bean.TableOrderCodeBean;
import com.fos.modules.tableOrder.bean.TableOrderFoodBean;
import com.fos.modules.tableOrder.dao.TableOrderFoodDao;
import com.fos.modules.tableOrder.entity.TableOrderFoodConEntity;
import com.fos.modules.tableOrder.entity.TableOrderFoodEntity;
import com.fos.modules.tableOrder.entity.TimeTableEntity;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Tony on 7/30/2016.
 */
@Service
public class TableOrderFoodService extends CurdService<TableOrderFoodDao, TableOrderFoodEntity> {


    //获取该订单下所有菜品
    public List<TableOrderFoodConEntity> getTableOrderFood(TableOrderCodeBean bean) {
        List<TableOrderFoodEntity> foodEntities = dao.getTableOrderFood(bean);
        //获取所有菜品ID
        List<Integer> foodId = new ArrayList<Integer>();
        List<Integer> orderId = new ArrayList<Integer>();
        List<TableOrderFoodEntity> foodEntityList = new ArrayList<TableOrderFoodEntity>();
        for (int i = 0; i < foodEntities.size(); i++) {
            TableOrderFoodEntity foodEntity = new TableOrderFoodEntity();
            if (i == 0) {
                foodId.add(foodEntities.get(i).getFoodId());
                orderId.add(foodEntities.get(i).getOrderId());
                foodEntity.setFoodId(foodEntities.get(i).getFoodId());
                foodEntity.setFoodNum(foodEntities.get(i).getFoodNum());
                foodEntity.setOrderId(foodEntities.get(i).getOrderId());
                List<String> pres = new ArrayList<String>();
                if (!"".equals(foodEntities.get(i).getFoodPre()) && foodEntities.get(i).getFoodPre() != null) {
                    pres.add(foodEntities.get(i).getFoodPre());
                }
                foodEntity.setFoodPres(pres);
                foodEntityList.add(foodEntity);
            } else {
                if (!foodId.contains(foodEntities.get(i).getFoodId())) {
                    foodId.add(foodEntities.get(i).getFoodId());
                    orderId.add(foodEntities.get(i).getOrderId());
                    foodEntity.setFoodId(foodEntities.get(i).getFoodId());
                    foodEntity.setFoodNum(foodEntities.get(i).getFoodNum());
                    foodEntity.setOrderId(foodEntities.get(i).getOrderId());
                    List<String> pres = new ArrayList<String>();
                    if (!"".equals(foodEntities.get(i).getFoodPre()) && foodEntities.get(i).getFoodPre() != null) {
                        pres.add(foodEntities.get(i).getFoodPre());
                    }
                    foodEntity.setFoodPres(pres);
                    foodEntityList.add(foodEntity);
                } else {
                    if (!orderId.contains(foodEntities.get(i).getOrderId())) {
                        foodId.add(foodEntities.get(i).getFoodId());
                        orderId.add(foodEntities.get(i).getOrderId());
                        foodEntity.setFoodId(foodEntities.get(i).getFoodId());
                        foodEntity.setFoodNum(foodEntities.get(i).getFoodNum());
                        foodEntity.setOrderId(foodEntities.get(i).getOrderId());
                        List<String> pres = new ArrayList<String>();
                        if (!"".equals(foodEntities.get(i).getFoodPre()) && foodEntities.get(i).getFoodPre() != null) {
                            pres.add(foodEntities.get(i).getFoodPre());
                        }
                        foodEntity.setFoodPres(pres);
                        foodEntityList.add(foodEntity);
                    } else {
                        List<String> pres = new ArrayList<String>();
                        for (TableOrderFoodEntity entity : foodEntities) {
                            if (entity.getOrderId() == foodEntities.get(i).getOrderId()) {
                                if (!"".equals(entity.getFoodPre()) && entity.getFoodPre() != null) {
                                    pres.add(entity.getFoodPre());
                                }
                                entity.setFoodPres(pres);
                            }
                        }
                    }
                }
            }
        }

        List<TimeTableEntity> timeTable = dao.getTimeTable();
        //实体转换（偏好口味封装）
        List<TableOrderFoodConEntity> conEntityList = new ArrayList<TableOrderFoodConEntity>();
        for (TableOrderFoodEntity foId : foodEntityList) {
            TableOrderFoodConEntity conEntity = new TableOrderFoodConEntity();
            List<String> foodPre = new ArrayList<String>();
            Date nowTime = new Date();
            for (TableOrderFoodEntity foodEntity : foodEntities) {
                if (foId.getFoodId() == foodEntity.getFoodId() && foId.getOrderId() == foodEntity.getOrderId()) {
                    if (foodEntity.getFoodPres() != null) {
                        conEntity.setFoodPre(foodEntity.getFoodPres());
                    } else {
                        conEntity.setFoodPre(foId.getFoodPres());
                    }
                    conEntity.setBeginTime(foodEntity.getBeginTime());
                    conEntity.setOrderId(foodEntity.getOrderId());
                    conEntity.setFoodId(foodEntity.getFoodId());
                    conEntity.setArriveTime(foodEntity.getArriveTime());
                    conEntity.setFoodName(foodEntity.getFoodName());
                    conEntity.setFoodNum(foodEntity.getFoodNum());
                    conEntity.setFoodImg(foodEntity.getFoodImg());
                    long tmpTime = 0l;
                    if (foodEntity.getArriveTime() == null) {
                        tmpTime = (nowTime.getTime() - foodEntity.getBeginTime().getTime()) / 1000;
                    } else {
                        tmpTime = (foodEntity.getArriveTime().getTime() - foodEntity.getBeginTime().getTime()) / 1000;
                    }
                    String minStr = String.valueOf((tmpTime / 60)).length()<2?("0"+(tmpTime / 60)):(tmpTime / 60)+"";
                    String secStr = String.valueOf((tmpTime % 60)).length()<2?("0"+(tmpTime % 60)):(tmpTime % 60)+"";
                    conEntity.setIntervalTime( minStr+ ":" + secStr);
                    conEntity.setRemark(foodEntity.getRemark());
                    if (foodEntity.getArriveTime() == null) {
                        Long diff = (System.currentTimeMillis() - foodEntity.getBeginTime().getTime()) / (1000 * 60);
                        int diffMin = diff.intValue();
                        for (TimeTableEntity tableEntity : timeTable) {
                            if (tableEntity.getEndTime() != 0) {
                                if (tableEntity.getStartTime() < diffMin && diffMin < tableEntity.getEndTime()) {
                                    conEntity.setColor(tableEntity.getColor());
                                    break;
                                }
                            } else {
                                if (tableEntity.getStartTime() < diffMin) {
                                    conEntity.setColor(tableEntity.getColor());
                                    break;
                                }
                            }
                        }
                    }
                }
            }
//            conEntity.setFoodPre(foId.getFoodPres());
            conEntityList.add(conEntity);
        }
        return conEntityList;
    }


    //获取当前订单送达状态
    public boolean getOrderFoodStatus(TableOrderCodeBean bean) {
        List<TableOrderFoodEntity> foodEntities = dao.getTableOrderFood(bean);
        boolean flag = true;
        for (TableOrderFoodEntity foodEntity : foodEntities) {
            if (foodEntity.getStatus() == 1) {
                flag = false;
                break;
            }
        }
        return flag;
    }

    //更改当前订单下的菜品状态
    public void changeOrderFoodStatus(TableOrderFoodBean bean) {
        dao.changeOrderFoodStatus(bean);
    }

    //更改当前订单下的所有菜品状态
    public void changeAllOrderFoodStatus(TableOrderCodeBean bean) {
        dao.changeAllOrderFoodStatus(bean);
    }

    //更改当前订单状态
    public void changeOrderStatus(TableOrderCodeBean bean) {
        dao.changeOrderStatus(bean);
    }

}
