package com.fos.modules.tableOrder.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.fos.core.base.BaseEntity;
import com.fos.core.conf.GConstants;

import java.util.Date;
import java.util.List;

/**
 * Created by Tony on 7/30/2016.
 */
public class TableOrderFoodEntity extends BaseEntity {

    @JSONField(name = "foodId")
    private int foodId;    //菜品id

    @JSONField(name = "foodName")
    private String foodName;    //菜品名称
    
    @JSONField(name = "foodNum")
    private String foodNum;    //菜品数量

    @JSONField(name = "beginTime")
    private Date beginTime;  //起始时间

    @JSONField(name = "arriveTime")
    private Date arriveTime;  //送达时间

    @JSONField(name = "foodPre")
    private String foodPre;   //菜品口味

    @JSONField(name = "remark")
    private String remark;  //菜品备注

    @JSONField(serialize = false)
    private int status;     //送达状态0未送达，1已送达

    @JSONField(serialize = false)
    private int orderId;

    @JSONField(name = "foodPres")
    private List<String> foodPres;   //菜品口味

    @JSONField(name = "foodImg")
    private String foodImg; // 食物图片

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getFoodId() {
        return foodId;
    }

    public void setFoodId(int foodId) {
        this.foodId = foodId;
    }

    public String getFoodName() {
        return foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public Date getArriveTime() {
        return arriveTime;
    }

    public void setArriveTime(Date arriveTime) {
        this.arriveTime = arriveTime;
    }

    public String getFoodPre() {
        return foodPre;
    }

    public void setFoodPre(String foodPre) {
        this.foodPre = foodPre;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public int getOrderId() {
        return orderId;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    public List<String> getFoodPres() {
        return foodPres;
    }

    public void setFoodPres(List<String> foodPres) {
        this.foodPres = foodPres;
    }

    public String getFoodImg() {
        return foodImg;
    }

    public void setFoodImg(String foodImg) {
        this.foodImg = GConstants.FILE_PREFIX_URL + foodImg;
    }

	public String getFoodNum() {
		return foodNum;
	}

	public void setFoodNum(String foodNum) {
		this.foodNum = foodNum;
	}
    
    
}
