package com.fos.modules.tableOrder.api;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.tableOrder.bean.TableOrderBean;
import com.fos.modules.tableOrder.bean.TableOrderCodeBean;
import com.fos.modules.tableOrder.bean.TableOrderFoodBean;
import com.fos.modules.tableOrder.entity.TableOrderFoodConEntity;
import com.fos.modules.tableOrder.entity.TableOrderUserEntity;
import com.fos.modules.tableOrder.entity.TableUserEntity;
import com.fos.modules.tableOrder.service.TableOrderFoodService;
import com.fos.modules.tableOrder.service.TableOrderUserService;
import com.fos.modules.tableOrder.service.TableUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * Created by Tony on 7/30/2016.
 */
@Controller
@RequestMapping(value = "/api/tableOrder")
public class TableOrderController {

    @Autowired
    private TableOrderFoodService foodService;
    @Autowired
    private TableOrderUserService userService;
    @Autowired
    private TableUserService tableUserService;


    @ResponseBody
    @RequestMapping(value = "/getTableOrder")
    public ResponseBean getTableOrder(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableOrderBean bean = requestBean.getObjectBean(TableOrderBean.class);
        String message = userService.validate(bean);
        if (message == null) {
            List<TableOrderUserEntity> userEntityList = userService.getTableOrderUser(bean);
            if (userEntityList.size() > 0) {
                for (int i = 0; i < userEntityList.size(); i++) {
                    TableOrderCodeBean codeBean = new TableOrderCodeBean();
                    codeBean.setCode(userEntityList.get(i).getOrderCode());
                    List<TableOrderFoodConEntity> foodConEntityList = foodService.getTableOrderFood(codeBean);
                    userEntityList.get(i).setFoodList(foodConEntityList);
                }
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                responseBean.setData(userEntityList);
                return responseBean;
            } else {
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                responseBean.setMessage("No such user");
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }


    @ResponseBody
    @RequestMapping(value = "/getTableOrderByCode")
    public ResponseBean getTableOrderByCode(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableOrderCodeBean bean = requestBean.getObjectBean(TableOrderCodeBean.class);
        String message = userService.validate(bean);
        if (message == null) {
            TableOrderUserEntity userEntityList = userService.getTableOrderUserByCode(bean);
            if (userEntityList != null) {
                List<TableOrderFoodConEntity> foodConEntityList = foodService.getTableOrderFood(bean);
                userEntityList.setFoodList(foodConEntityList);
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                responseBean.setData(userEntityList);
                return responseBean;
            } else {
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                responseBean.setMessage("No such user");
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/getTableUser")
    public ResponseBean getTableUser(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableOrderBean bean = requestBean.getObjectBean(TableOrderBean.class);
        String message = tableUserService.validate(bean);
        if (message == null) {
            List<TableUserEntity> userEntityList = tableUserService.getTableUser(bean);
            if (userEntityList.size() > 0) {
                responseBean.setMessage(GConstants.OK);
                responseBean.setStatus(GConstants.STATUS_CODE_2000);
                responseBean.setData(userEntityList);
                return responseBean;
            } else {
                responseBean.setStatus(GConstants.STATUS_CODE_2001);
                responseBean.setMessage("No such user");
                return responseBean;
            }
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/changeOrderFoodStatus")
    public ResponseBean changeOrderFoodStatus(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableOrderFoodBean bean = requestBean.getObjectBean(TableOrderFoodBean.class);
        String message = foodService.validate(bean);
        if (message == null) {
            foodService.changeOrderFoodStatus(bean);
            TableOrderCodeBean codeBean = new TableOrderCodeBean();
            codeBean.setCode(bean.getCode());
//            boolean flag = foodService.getOrderFoodStatus(codeBean);
//            if (!flag) {
//                foodService.changeOrderStatus(codeBean);
//            }
            responseBean.setMessage(GConstants.OK);
            responseBean.setStatus(GConstants.STATUS_CODE_2000);
            return responseBean;
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }

    @ResponseBody
    @RequestMapping(value = "/changeAllOrderFoodStatus")
    public ResponseBean changeAllOrderFoodStatus(RequestBean requestBean) {
        ResponseBean responseBean = new ResponseBean();
        TableOrderCodeBean bean = requestBean.getObjectBean(TableOrderCodeBean.class);
        String message = foodService.validate(bean);
        if (message == null) {
            foodService.changeAllOrderFoodStatus(bean);
            //foodService.changeOrderStatus(bean);
            responseBean.setMessage(GConstants.OK);
            responseBean.setStatus(GConstants.STATUS_CODE_2000);
            return responseBean;
        }
        responseBean.setMessage(message);
        responseBean.setStatus(GConstants.STATUS_CODE_4001);
        return responseBean;
    }
}
