package com.fos.modules.printOrder.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Service;

import com.fos.core.base.CurdService;
import com.fos.modules.printOrder.dao.PrintOrderDao;
import com.fos.modules.printOrder.entity.OrderEntity;
import com.fos.modules.printOrder.entity.PrintOrderEntity;
import com.fos.modules.printOrder.entity.SubFoodEntity;

@Service
public class PrintOrderService  extends CurdService<PrintOrderDao, PrintOrderEntity>{

	// 获取订单打印信息
    public PrintOrderEntity getPrintOrderInfo(String loginName, String orderId) {
    	
    	PrintOrderEntity printOrder = new PrintOrderEntity();
        // 根据登录名字检索
    	List<PrintOrderEntity> userInfoList = dao.getUserInfo(loginName);
    	if(userInfoList != null && userInfoList.size() > 0){
    		// 获取工作人员信息
    		printOrder.setSysName(userInfoList.get(0).getSysName());
    		// 获取地点
    		printOrder.setOfficeName(userInfoList.get(0).getOfficeName());
    	}else{
    		// 获取工作人员信息
    		printOrder.setSysName("");
    		// 获取地点
    		printOrder.setOfficeName("");
    	}
    	
    	// 获取订单信息
    	List<OrderEntity> orderInfoList = dao.getOrderInfo(orderId);
    	// 如果没有获得值，退出
    	if(userInfoList == null || userInfoList.size() == 0){
    		return null;
    	}
    	
    	// 循环订单信息
    	for (OrderEntity orderEntity : orderInfoList) {
    		// 获取口味信息
			List<String> foodPreList = dao.getFoodPreInfo(orderEntity.getOrderFoodId());
			// 设置口味信息
			orderEntity.setFoodPreList(foodPreList);
			// 如果是套餐
			if("1".equals(orderEntity.getSetType())){
				// 拼写菜品Id
				String[] foodIdArr = orderEntity.getContain().split(",");
				// 获取套餐内容名称
				List<SubFoodEntity> foodNameList =	dao.getFoodNameInfo(foodIdArr);
				// 设置套餐内容
				orderEntity.setFoodNameList(foodNameList);
			}
			else{
				orderEntity.setFoodNameList(new ArrayList<SubFoodEntity>());
			}
		}
    	
    	printOrder.setOrderList(orderInfoList);
    	
    	return printOrder;
    }
    
    
    public void updatePrintStatus(List<OrderEntity> orderEntityList) {
    	for (OrderEntity orderEntity : orderEntityList) {
    		dao.updatePrintStatus(orderEntity);
		}
    }
	
}
