package com.fos.modules.printOrder.api;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.order.bean.OrderPrintBean;
import com.fos.modules.printOrder.entity.PrintOrderEntity;
import com.fos.modules.printOrder.service.PrintOrderService;
import com.fos.modules.printOrder.util.PrintTicket;

@Controller
@RequestMapping(value = "/api/PrintOrderController")
public class PrintOrderController {

	@Autowired
	private PrintOrderService printOrderService;

	@ResponseBody
	@RequestMapping(value = "/orderPrint")
	public ResponseBean orderPrint(RequestBean requestBean) {
		ResponseBean responseBean = new ResponseBean();
		OrderPrintBean bean = requestBean.getObjectBean(OrderPrintBean.class);
		String message = printOrderService.validate(bean);
		if (message == null) {
			// 获取订单code
			String orderId = bean.getOrderId();
			// 获取工作人员名称
			String sysName = bean.getSysName();

			PrintOrderEntity entity = printOrderService.getPrintOrderInfo(
					sysName, orderId);

			entity.setSysName(sysName);
			String retStr = PrintTicket.PrintTicket(entity);

			if (retStr == GConstants.STATUS_CODE_4002) {
				responseBean.setMessage("order print failed");
				responseBean.setStatus(GConstants.STATUS_CODE_4002);
				return responseBean;
			} else {
				printOrderService.updatePrintStatus(entity.getOrderList());
			}

		}
		responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_2000);
		return responseBean;
	}
}
