package com.fos.modules.orderView.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Service;

import com.fos.core.base.CurdService;
import com.fos.core.base.PageEntity;
import com.fos.core.conf.GConstants;
import com.fos.modules.orderView.bean.OrderViewBean;
import com.fos.modules.orderView.dao.OrderViewDao;
import com.fos.modules.orderView.entity.FoodEntity;
import com.fos.modules.orderView.entity.NameEntity;
import com.fos.modules.orderView.entity.OrderEntity;
import com.fos.modules.orderView.entity.OrderViewEntity;
import com.fos.modules.orderView.entity.TableEntity;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;



@Service
public class OrderViewService extends CurdService<OrderViewDao, OrderViewEntity>{

	//获取该桌号下所有的用户
	public List<NameEntity> getUserNickName(OrderViewBean orderViewBean){
		
			List<NameEntity> a = dao.getUserNickName(orderViewBean);
			return a;
	}
	
	//获取该用户下订单次数，以及订单详情
	public OrderEntity getOrderListCount(OrderViewBean orderViewBean){
		 
		return	dao.getOrderListCount(orderViewBean);
	}
	
	//查询该用户下订单详情
	public List<FoodEntity> getFoodList(OrderViewBean orderViewBean){
		
		return dao.getFoodList(orderViewBean);
	}
	
	//根据用户名把用户结束时间更新 
	public int updateUserEndTime(OrderViewBean orderViewBean){
		
		int updateUserEndTime = dao.updateUserEndTime(orderViewBean);
		return updateUserEndTime;
	}
	
	//获取桌子不为空
	public List<TableEntity> getOrderTable(){
		
		return dao.getOrderTable();
	}
	
	//根据endTime获取桌子为空
	public List<TableEntity> getOrderTableNull(){
			
		return dao.getOrderTableNull();
	}
	
	//通过桌号获取桌子的创建时间
	public TableEntity getTableCreateTime(OrderViewBean orderViewBean){
		return dao.getTableCreateTime(orderViewBean);
	}
	
	//获取订单的创建时间
	public List<OrderEntity> getOrderCreateTime(TableEntity tableEntity){
		return dao.getOrderCreateTime(tableEntity);
	}
	
	//获取订单的创建时间
	public List<OrderEntity> getOrderCreateTimeNull(TableEntity tableEntity){
		return dao.getOrderCreateTimeNull(tableEntity);
	}
	//获取已入座没下单的人
	public List<NameEntity> getName(){
		return dao.getName();
	}
	
	//已入座已下单的人
	public List<NameEntity> getNameHaveOrder(OrderViewBean orderViewBean){
		return dao.getNameHaveOrder(orderViewBean);
	}
	
	//没入座已结单的人
	public List<NameEntity> getNameHaveOrderNull(OrderViewBean orderViewBean){
			return dao.getNameHaveOrder(orderViewBean);
	}
	
	//查询该用户下订单详情
	public List<FoodEntity> getFoodListNull(OrderViewBean orderViewBean){
		return dao.getFoodListNull(orderViewBean);
	}
		
	//分页 inpress接口
	public PageEntity<TableEntity> getAllTableList(OrderViewBean orderViewBean){
		List<TableEntity> table = dao.getOrderTable();
		
		//获取今天0点到23点59分的时间
		 Calendar calendar = Calendar.getInstance();
		    calendar.setTime(new Date());
		    calendar.set(Calendar.HOUR_OF_DAY, 0);
		    calendar.set(Calendar.MINUTE, 0);
		    calendar.set(Calendar.SECOND, 0);
		     
		    Date start = calendar.getTime();
		 
		    calendar.add(Calendar.DAY_OF_MONTH, 1);
		    calendar.add(Calendar.SECOND, -1);
		     
		    Date end = calendar.getTime();
		 
		    System.out.println(start);
		    System.out.println(end);
		     
		    /* other way */
		    SimpleDateFormat formater = new SimpleDateFormat("yyyy/MM/dd");
		    SimpleDateFormat formater2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		     
		    try {
				start = formater2.parse(formater.format(new Date())+ " 00:00:00");
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		    try {
				end = formater2.parse(formater.format(new Date())+ " 23:59:59");
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		//获取总桌数，count
		int count = 0;
		for(int a=0;a<table.size();a++){
			count = table.size();
		}
		
		PageEntity<TableEntity> page = new PageEntity<TableEntity>();
		
		//每页几条诗句
		int pageSize = 3;
		//共几页
		int totalPage = count%pageSize == 0? count/pageSize : (count/pageSize)+1;
		//当前页
		int pageNo = orderViewBean.getPageNo();
		//当前页不能小于0大于总页数
		if(pageNo>0 && pageNo<=totalPage){
			//分页，当前页和每页几条数据
			PageHelper.startPage(pageNo,pageSize);
			 
			 TableEntity tableEntity = new TableEntity ();
				// 获取有人的桌号,根据status

			 //分页插件
			 PageInfo<TableEntity> pageInfo = new PageInfo<TableEntity>(dao.getOrderTable());
				  table = pageInfo.getList();
				  pageInfo.setPageNum(page.getPageNo());
				  pageInfo.setPageSize(pageSize);
				  pageInfo.setTotal(page.getTotalPage());
				  pageInfo.setList(table);
				//  pageInfo.set
				
				if (table != null ) {
					for (int j = 0; j < table.size(); j++) {
						//获取当前桌是哪桌
						int tableNum = table.get(j).getTableNum();
						
				 page.setPageNo(pageNo);
				 page.setCount(count);
				 page.setPageNo(pageNo);
				 page.setPageSize(pageInfo.getPageSize());
			 	 page.setTotalPage(totalPage);
			   	 page.setCount(pageInfo.getTotal());
			 	
				orderViewBean.setTableNum(tableNum);
				NameEntity nameEntity = new NameEntity();
				// 获取用户昵称
				//没下过单的用户
				List<NameEntity> nickname = dao.getName();
				
				//下过单的用户
				List<NameEntity> nicknameList = dao.getNameHaveOrder(orderViewBean);
				if (nicknameList != null) {
					for (int i = 0; i < nicknameList.size(); i++) {
						//获取用户状态
						nameEntity.setStatus(nicknameList.get(i).getStatus());
						String nickName = nicknameList.get(i).getNickname();
						orderViewBean.setNickName(nickName);
						//获取桌子开始时间
						TableEntity starttime = null;
						starttime = dao.getTableCreateTime(orderViewBean);
						long startTime = starttime.getStartTime();
						//比较时间是否为今天
						//if(	startTime > start.getTime() && startTime<end.getTime()){
							tableEntity.setStartTime(startTime);
						/*}*/
						OrderEntity orderEntity = new OrderEntity();
						
						// 获取每个用户名的订单次数
						OrderEntity userOrderList = dao.getOrderListCount(orderViewBean);
						// 获取订单创建时间
						List<OrderEntity> createTime = dao.getOrderCreateTime(tableEntity);
						for(OrderEntity order:createTime){
							//时间在今天范围内
							//if(order.getCreateTime()> start.getTime() && order.getCreateTime()<end.getTime()){
								orderEntity.setCreateTime(order.getCreateTime());
								orderViewBean.setCreateTime(order.getCreateTime());
								userOrderList.setCreateTime(order.getCreateTime());
							/*}	*/						
						}
						
						// 获取每个用户名的订单详情
						List<FoodEntity> foodList = dao.getFoodList(orderViewBean);
							if(foodList!=null){
								userOrderList.setFoodList(foodList);
								//将订单放入外层List
								nicknameList.get(i).setUserFoodList(userOrderList);
								//nicknameList.get(i).setUserFoodList(orderEntity);
					}
					table.get(j).setUserOrders(nicknameList);
					page.setList(table);
				}
			}
		}
	}
}
		return page;
}
			
	//没入座没下单的人
	public List<NameEntity> getNameNull(){
		return dao.getNameNull();
	}
	
	//分页  completed接口
	public PageEntity<TableEntity> getAllTableListNull(OrderViewBean orderViewBean){
		List<TableEntity> table = dao.getOrderTableNull();
		
		//获取今天0点到23点59分的时间
		 Calendar calendar = Calendar.getInstance();
		    calendar.setTime(new Date());
		    calendar.set(Calendar.HOUR_OF_DAY, 0);
		    calendar.set(Calendar.MINUTE, 0);
		    calendar.set(Calendar.SECOND, 0);
		     
		    Date start = calendar.getTime();
		 
		    calendar.add(Calendar.DAY_OF_MONTH, 1);
		    calendar.add(Calendar.SECOND, -1);
		     
		    Date end = calendar.getTime();
		 
		    System.out.println(start);
		    System.out.println(end);
		     
		    /* other way */
		    SimpleDateFormat formater = new SimpleDateFormat("yyyy/MM/dd");
		    SimpleDateFormat formater2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		     
		    try {
				start = formater2.parse(formater.format(new Date())+ " 00:00:00");
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		    try {
				end = formater2.parse(formater.format(new Date())+ " 23:59:59");
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		//获取共有多少桌子
		int count = 0;
		for(int a=0;a<table.size();a++){
			count = table.size();
		}
		
		PageEntity<TableEntity> page = new PageEntity<TableEntity>();
		//每页几条数据
		int pageSize = 3;
		//一共几页
		int totalPage = count%pageSize == 0? count/pageSize : (count/pageSize)+1;
		//当前页
		int pageNo = orderViewBean.getPageNo();
		//当前页不能小于0大于总页数
		if(pageNo>0&&pageNo<=totalPage){
			//分页
			PageHelper.startPage(pageNo,pageSize);
			 
			 TableEntity tableEntity = new TableEntity ();

			 PageInfo<TableEntity> pageInfo = new PageInfo<TableEntity>(dao.getOrderTableNull());
				  table = pageInfo.getList();
				  pageInfo.setPageNum(page.getPageNo());
				  pageInfo.setPageSize(pageSize);
				  pageInfo.setTotal(page.getTotalPage());
				  pageInfo.setList(table);
				//  pageInfo.set
				
				if (table != null ) {
					for (int j = 0; j < table.size(); j++) {
						
						//获取当前桌号
						int tableNum = table.get(j).getTableNum();
						TableEntity tableentity = dao.getTableCreateTime(orderViewBean);
					//	long startTime = table.get(j).getStartTime();
						
					//	orderViewBean.setStartTime(startTime);

				page.setPageNo(pageInfo.getPageNum());
			 	page.setPageSize(pageInfo.getPageSize());
			 	page.setTotalPage(totalPage);
			 	page.setCount(pageInfo.getTotal());
			 	page.setPageNo(pageNo);
				page.setCount(count);
				page.setTotalPage(totalPage);
			 	
				orderViewBean.setTableNum(tableNum);
				 // 获取没下过单的用户昵称
				List<NameEntity> nickname = dao.getNameNull();
				 // 获取下过单的用户昵称
				List<NameEntity> nicknameList = dao.getNameHaveOrderNull(orderViewBean);
		
				if (nicknameList != null) {
					for (int i = 0; i < nicknameList.size(); i++) {
						int b = nicknameList.size();
						String nickName = nicknameList.get(i).getNickname();
						orderViewBean.setNickName(nickName);
						
						// 获取每个用户名的订单次数
						OrderEntity userOrderList = dao.getOrderListCount(orderViewBean);
						tableEntity.setTableNum(tableNum);
						//获取订单创建时间
					/*	List<OrderEntity> createTime = dao.getOrderCreateTimeNull(tableEntity);
						//orderViewBean.setCreateTime(createTime.getCreateTime());
						for(OrderEntity order:createTime){
						//	if(order.getCreateTime()> start.getTime() && order.getCreateTime()<end.getTime()){
							//	orderEntity.setCreateTime(order.getCreateTime());
								orderViewBean.setCreateTime(order.getCreateTime());
								userOrderList.setCreateTime(order.getCreateTime());
								userOrderList.setEndTime(order.getEndTime());
						//	}							
						}*/
						// 获取每个用户名的订单详情
						List<FoodEntity> foodList = dao.getFoodListNull(orderViewBean);
							if(foodList!=null){
								userOrderList.setFoodList(foodList);
								nicknameList.get(i).setUserFoodList(userOrderList);
						}
				}   
					table.get(j).setUserOrders(nicknameList);
			}		page.setList( table);
		}
	}
}
		return page;
}
	
}