package com.fos.modules.orderView.dao;

import java.util.List;

import com.fos.core.base.CurdDao;
import com.fos.modules.orderView.bean.OrderViewBean;
import com.fos.modules.orderView.entity.FoodEntity;
import com.fos.modules.orderView.entity.NameEntity;
import com.fos.modules.orderView.entity.OrderEntity;
import com.fos.modules.orderView.entity.OrderViewEntity;
import com.fos.modules.orderView.entity.TableEntity;

public interface OrderViewDao extends CurdDao<OrderViewEntity>{

	//获取有人的桌号,根据endTime
	public List<TableEntity> getOrderTable();
	//获取没有人的桌号,根据endTime
	public List<TableEntity> getOrderTableNull();
	//通过桌号获取用户昵称
	public List<NameEntity> getUserNickName(OrderViewBean orderViewBean);
	//查询该用户下订单次数
	public OrderEntity getOrderListCount(OrderViewBean orderViewBean);
	//查询该用户下订单详情
	public List<FoodEntity> getFoodList(OrderViewBean orderViewBean);
	//查询该用户下订单详情
	public List<FoodEntity> getFoodListNull(OrderViewBean orderViewBean);
	//根据用户名把用户结束时间更新 
	public int updateUserEndTime(OrderViewBean orderViewBean);
	//获取所有桌号的信息
	public TableEntity getAllTableList(TableEntity tableEntity);
	//通过桌号获取桌子的创建时间
	public TableEntity getTableCreateTime(OrderViewBean orderViewBean);
	//获取订单的创建时间
	public List<OrderEntity> getOrderCreateTime(TableEntity tableEntity);
	//获取订单的创建时间
	public List<OrderEntity> getOrderCreateTimeNull(TableEntity tableEntity);
	//已入座没下单的人
	public List<NameEntity> getName();
	//没入座没下单的人
	public List<NameEntity> getNameNull();
	//已入座已下单的人
	public List<NameEntity> getNameHaveOrder(OrderViewBean orderViewBean);
	//没入座已结单的人
	public List<NameEntity> getNameHaveOrderNull(OrderViewBean orderViewBean);
}
