package com.fos.modules.orderView.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.base.PageEntity;
import com.fos.core.conf.GConstants;
import com.fos.modules.orderView.bean.OrderViewBean;
import com.fos.modules.orderView.entity.FoodEntity;
import com.fos.modules.orderView.entity.NameEntity;
import com.fos.modules.orderView.entity.OrderEntity;
import com.fos.modules.orderView.entity.TableEntity;
import com.fos.modules.orderView.service.OrderViewService;


@Controller
@RequestMapping(value = "/api/orderView")
public class OrderViewController {

	@Autowired
	private OrderViewService orderViewService;

	// inpress接口
	@ResponseBody
	@RequestMapping(value = "/getUserInProgress")
	public ResponseBean getUserInProgress(RequestBean requestBean,PageEntity<TableEntity> page) {
		ResponseBean responseBean = new ResponseBean();
		OrderViewBean orderViewBean = requestBean.getObjectBean(OrderViewBean.class);
		String message = orderViewService.validate(orderViewBean);
		if (message == null) {
			TableEntity tableEntity = new TableEntity ();
			// 获取有人的桌号,根据status
			List<TableEntity> table = orderViewService.getOrderTable();
			
			if(table.size()>0) {
				for (int j = 0; j < table.size(); j++) {
					int count = table.size();

					int tableNum = table.get(j).getTableNum();
					tableEntity.setTableNum(tableNum);
					orderViewBean.setTableNum(tableNum);
					// 获取用户昵称
					List<NameEntity> nicknameList = orderViewService.getNameHaveOrder(orderViewBean);
			
					if (nicknameList != null) {
						for (int i = 0; i < nicknameList.size(); i++) {
							int b = nicknameList.size();
							
							// 获取每个用户名的订单次数
							OrderEntity userOrderList = orderViewService.getOrderListCount(orderViewBean);
							
							// 获取每个用户名的订单详情
							List<FoodEntity> foodList = orderViewService.getFoodList(orderViewBean);
								if(foodList==null){
									responseBean.setStatus(GConstants.STATUS_CODE_2000);
									responseBean.setMessage("He didn't order a meal.");
									return responseBean;
								}
						}
						table.get(j).setUserOrders(nicknameList);
						
					}else{
						responseBean.setStatus(GConstants.STATUS_CODE_2000);
						responseBean.setMessage("No one on this table");
						return responseBean;
					}
					
					
					//分页
					PageEntity<TableEntity> pages = orderViewService.getAllTableList(orderViewBean);
					responseBean.setMessage(GConstants.OK);
					responseBean.setStatus(GConstants.STATUS_CODE_2000);
					responseBean.setData(pages);
					return responseBean;
			
				}
				
				
			}else {
				responseBean.setStatus(GConstants.STATUS_CODE_2000);
				responseBean.setMessage("The table is empty.");
				return responseBean;
			}
		}
		// responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_4001);
		return responseBean;
	}

	//	@ResponseBody
	//	@RequestMapping(value = "/getUserCheckOut")
	//	public ResponseBean getUserCheckOut(RequestBean requestBean) {
	//		ResponseBean responseBean = new ResponseBean();
	//		OrderViewBean orderViewBean = requestBean.getObjectBean(OrderViewBean.class);
	//		String message = orderViewService.validate(orderViewBean);
	//		if (message == null) {
	//			int updateUserEndTime = orderViewService.updateUserEndTime(orderViewBean);
	//			if (updateUserEndTime > 0) {
	//				responseBean.setMessage(GConstants.OK);
	//				responseBean.setStatus(GConstants.STATUS_CODE_2000);
	//				return responseBean;
	//			}
	//		}
	//		responseBean.setMessage(message);
	//		responseBean.setStatus(GConstants.STATUS_CODE_4001);
	//		return responseBean;
	//	}

	// Completed接口
	@ResponseBody
	@RequestMapping(value = "/getUserCompleted")
	public ResponseBean getUserCompleted(RequestBean requestBean,PageEntity<TableEntity> page) {
		ResponseBean responseBean = new ResponseBean();
		OrderViewBean orderViewBean = requestBean.getObjectBean(OrderViewBean.class);
		String message = orderViewService.validate(orderViewBean);
		if (message == null) {
			TableEntity tableEntity = new TableEntity ();
			// 获取没人的桌号,根据status
			List<TableEntity> table = orderViewService.getOrderTableNull();
			
			//获取今天0点到23点59分的时间
			 Calendar calendar = Calendar.getInstance();
			    calendar.setTime(new Date());
			    calendar.set(Calendar.HOUR_OF_DAY, 0);
			    calendar.set(Calendar.MINUTE, 0);
			    calendar.set(Calendar.SECOND, 0);
			     
			    Date start = calendar.getTime();
			 
			    calendar.add(Calendar.DAY_OF_MONTH, 1);
			    calendar.add(Calendar.SECOND, -1);
			     
			    Date end = calendar.getTime();
			 
			    System.out.println(start);
			    System.out.println(end);
			     
			    /* other way */
			    SimpleDateFormat formater = new SimpleDateFormat("yyyy/MM/dd");
			    SimpleDateFormat formater2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
			     
			    try {
					start = formater2.parse(formater.format(new Date())+ " 00:00:00");
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			    try {
					end = formater2.parse(formater.format(new Date())+ " 23:59:59");
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			
			if(table.size()>0) {
				for (int j = 0; j < table.size(); j++) {
					int count = table.size();

					int tableNum = table.get(j).getTableNum();
					tableEntity.setTableNum(tableNum);
					
					orderViewBean.setTableNum(tableNum);
					
					//没下过单的人
					List<NameEntity> nickname = orderViewService.getNameNull();
					//下过单的人
					List<NameEntity> nicknameList = orderViewService.getNameHaveOrderNull(orderViewBean);
			
					if (nicknameList != null) {
						for (int i = 0; i < nicknameList.size(); i++) {
							int b = nicknameList.size();
							String nickName = nicknameList.get(i).getNickname();
							orderViewBean.setNickName(nickName);
							/*TableEntity starttime = null;
							starttime = orderViewService.getTableCreateTime(orderViewBean);
							long startTime = starttime.getStartTime();
							if(	startTime > start.getTime() && startTime<end.getTime()){
								tableEntity.setStartTime(startTime);
							}*/
							OrderEntity orderEntity = new OrderEntity();
							
							// 获取每个用户名的订单次数
							OrderEntity userOrderList = orderViewService.getOrderListCount(orderViewBean);
							
							// 获取每个用户名的订单详情
							List<FoodEntity> foodList = orderViewService.getFoodListNull(orderViewBean);
								if(foodList!=null){
									userOrderList.setFoodList(foodList);
									nicknameList.get(i).setUserFoodList(userOrderList);
								}else{
									responseBean.setStatus(GConstants.STATUS_CODE_2000);
									responseBean.setMessage("He didn't order a meal.");
									return responseBean;
								}
						}
						table.get(j).setUserOrders(nicknameList);
						
					}else{
						responseBean.setStatus(GConstants.STATUS_CODE_2000);
						responseBean.setMessage("No one on this table");
						return responseBean;
					}
					//分页
					PageEntity<TableEntity> pages = orderViewService.getAllTableListNull(orderViewBean);
					
					
					responseBean.setMessage(GConstants.OK);
					responseBean.setStatus(GConstants.STATUS_CODE_2000);
					responseBean.setData(pages);
					return responseBean;
			
				}
				
			}else {
				responseBean.setStatus(GConstants.STATUS_CODE_2000);
				responseBean.setMessage("The table is empty.");
				return responseBean;
			}
		}
		responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_4001);
		return responseBean;
	}

}