package com.fos.modules.order.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.fos.core.base.CurdService;
import com.fos.core.util.Util;
import com.fos.modules.order.bean.OrderBean;
import com.fos.modules.order.bean.OrderPrintBean;
import com.fos.modules.order.dao.OrderDao;
import com.fos.modules.order.entity.FoodEntity;
import com.fos.modules.order.entity.FoodPreEntity;
import com.fos.modules.order.entity.OrderCoderIdEntity;
import com.fos.modules.order.entity.OrderEntity;
import com.fos.modules.order.entity.UserSeatEntity;
import com.fos.modules.vipuser.service.VipUserService;

@Service
public class OrderService extends CurdService<OrderDao, OrderEntity> {

	/*
	 * //更改当前订单状态 public void updateOrder(OrderEntity entity) {
	 * dao.updateOrder(entity); } //插入新订单 public void addOrder(OrderBean entity)
	 * { dao.addOrder(entity);
	 * 
	 * }
	 * 
	 * //查询user2seat信息 public List<UserSeatEntity> checkUserSeat(){ return
	 * dao.checkUserSeat(); } public String checkUserSeat(int seatId, int
	 * userId){ return dao.checkUserSeat(seatId, userId); } //插入user2seat public
	 * void addUserSeat(OrderBean userSeatEntity){
	 * dao.addUserSeat(userSeatEntity); } //检查订单code public OrderEntity
	 * checkOrderCode(OrderBean bean){ return dao.checkOrderCode(bean); }
	 * 
	 * //获取SeatId public int getSeatId(int tableNum, String tableArea){ return
	 * dao.getSeatId(tableNum, tableArea); }
	 * 
	 * public int getOrderId(String code){ return dao.getOrderId(code); }
	 * 
	 * //检查食品id public List<OrderEntity> checkOrder2FoodId(String orderCode){
	 * List<OrderEntity> foodPreEntities = dao.checkOrder2FoodId(orderCode);
	 * return foodPreEntities; }
	 * 
	 * //更改当前订单状态 public void updateOrderFood(OrderEntity entity) {
	 * dao.updateOrderFood(entity); } //插入新订单 public void
	 * addOrderFood(OrderEntity entity) { dao.addOrderFood(entity); }
	 * 
	 * public String getOrderFoodId(OrderEntity entity){ return
	 * dao.getOrderFoodId(entity); } //插入口味 public void
	 * addOrderFoodPre(FoodPreEntity foodPreEntity){
	 * dao.addOrderFoodPre(foodPreEntity); } //插入用户食品 public void
	 * addUserFood(OrderEntity orderEntitys){ dao.addUserFood(orderEntitys); }
	 * //插入用户口味 public void addUserPre(FoodPreEntity foodPreEntities){
	 * dao.addUserPre(foodPreEntities); }
	 */
	
	@Autowired
	private VipUserService vipUserDao;

	public OrderCoderIdEntity Order(OrderBean bean) {
		// 通过userName获取userId
		int userId = vipUserDao.getUserId(bean.getUserName());
		bean.setUserId(userId);
		// 通过TableNum获取seatId
		int seatId = dao.getSeatId(bean.getTableNum(),
				bean.getTableArea());
		bean.setSeatId(seatId);
		String userSeat = dao.checkUserSeat(seatId, userId);
		// 添加user2seat信息
		if (userSeat == null || userSeat == "") {
			dao.addUserSeat(bean);
		}
		// 通过bean获取orderCode和orderId
		OrderEntity orderEntity = dao.checkOrderCode(bean);
		// 如果没有下过单
		int orderId;
		OrderCoderIdEntity orderCoderIdEntity = new OrderCoderIdEntity();
		if (orderEntity == null) {
			// 创建一个order随机码
			String code = Util.getGenericUUID();
			// 把code传到bean
			bean.setOrderCode(code);
			// 新增订单
			dao.addOrder(bean);
			// 通过code得到orderId
			orderId = dao.getOrderId(code);
			// 把orderId传到bean
			bean.setOrderId(orderId);
			// 新建OrderCoderIdEntity来接收code，orderId，OrderStatus

			// 开始添加OrderCodeId
			orderCoderIdEntity.setOrderCode(code);
			orderCoderIdEntity.setOrderId(orderId);
			orderCoderIdEntity.setOrderStatus("0");
			// 结束添加OrderCodeId
		} else {
			// 如果下过单
			orderId = orderEntity.getOrderId();
			bean.setOrderId(orderId);
			// orderList加入sysname
			orderEntity.setSys_name(bean.getSysName());
			if (orderEntity != null) {
				// 更新订单
				dao.updateOrder(orderEntity);
			}
			// 开始添加OrderCodeId
			orderCoderIdEntity.setOrderCode(orderEntity.getOrderCode());
			orderCoderIdEntity.setOrderId(orderId);
			orderCoderIdEntity.setOrderStatus("0");
			// 结束添加OrderCodeId
		}
		if (bean.getFood() != null && bean.getFood().size() != 0) {
			// 获取bean中的food信息
			for (int j = 0; j < bean.getFood().size(); j++) {
				// 创建新的OrderEntity来接收bean中的userId，foodId，foodNum，remark，orderId
				OrderEntity order2Entity = new OrderEntity();
				order2Entity.setUserId(bean.getUserId());
				order2Entity.setFoodId(bean.getFood().get(j).getFoodId());
				order2Entity.setFoodNum(bean.getFood().get(j).getFoodNum());
				// 防止remark信息为空
				if (bean.getFood().get(j).getRemark() != null) {
					order2Entity.setRemark(bean.getFood().get(j).getRemark());
				}
				order2Entity.setOrderId(orderId);
				// 新增信息到vip_order2food
				dao.addOrderFood(order2Entity);
				dao.addUserFood(order2Entity); 
				int orderFoodId = order2Entity.getOrderId();
				// 如果下单食品不包含口味信息
				if (bean.getFood().get(j).getPreId() == null) {
					continue;
				} else {
					// 如果下单食品包含口味信息
					// 获取口味信息
					List<Integer> preId = bean.getFood().get(j).getPreId();
					for (int k = 0; k < preId.size(); k++) {
						// 创建新的FoodPreEntity来接收preId，PreNum，OrderFoodId，userId
						FoodPreEntity fpe = new FoodPreEntity();
						if (preId.get(k) != null) {
							fpe.setPreId(preId.get(k));
						}
						if (bean.getFood().get(j).getPreNum() != 0) {
							fpe.setPreNum(bean.getFood().get(j).getPreNum());
						}
						fpe.setOrderFoodId(orderFoodId);
						fpe.setUserId(userId);
						// 插入数据到vip_orderfood2pre和vip_user2pre
						dao.addOrderFoodPre(fpe);
						dao.addUserPre(fpe);
					}
				}
			}
		}
		return orderCoderIdEntity;
	}

	// 查询订单打印状态
	public int getOrderPrint(OrderPrintBean bean) {
		return dao.getOrderPrint(bean);
	}
}
