package com.fos.modules.order.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.fos.core.base.CurdDao;
import com.fos.modules.order.bean.OrderBean;
import com.fos.modules.order.bean.OrderPrintBean;
import com.fos.modules.order.entity.FoodPreEntity;
import com.fos.modules.order.entity.OrderEntity;
import com.fos.modules.order.entity.UserSeatEntity;

public interface OrderDao extends CurdDao<OrderEntity> {

	// 获取订单code
	public OrderEntity checkOrderCode(OrderBean bean);

	// 获取SeatId
	public int getSeatId(@Param(value = "tableNum") int tableNum,
			@Param(value = "tableArea") String tableArea);

	// 获取orderId
	public int getOrderId(String code);

	// 修改订单
	public void updateOrder(OrderEntity entity);

	// 插入订单信息
	public void addOrder(OrderBean entity);

	// 查询user2seat信息
	//public List<UserSeatEntity> checkUserSeat();
	public String checkUserSeat(@Param(value = "seatId") int seatId,
			@Param(value = "userId") int userId);
	
	// 添加user2seat信息
	public void addUserSeat(OrderBean userSeatEntity);

	// 查询当前订单下的订单口味
	public List<OrderEntity> checkOrder2FoodId(String code);

	// 修改菜品信息
	public void updateOrderFood(OrderEntity entity);

	// 添加食品信息
	public void addOrderFood(OrderEntity entity);

	// 添加食品口味信息
	public void addOrderFoodPre(FoodPreEntity foodPreEntity);

	// 添加用户食品信息
	public void addUserFood(OrderEntity orderEntitys);

	// 添加用户口味信息
	public void addUserPre(FoodPreEntity foodPreEntities);

	// 获取SeatId
	public String getOrderFoodId(OrderEntity entity);

	// 查询订单打印状态
	public int getOrderPrint(OrderPrintBean bean);

}