package com.fos.modules.order.bean;


import java.util.List;

import javax.validation.constraints.NotNull;


import com.alibaba.fastjson.annotation.JSONField;
import com.fos.core.base.BaseBean;
import org.hibernate.validator.constraints.NotEmpty;

public class OrderBean extends BaseBean {
    @NotNull(message = "座位号不能为NULL")
    @JSONField(name = "tableNum")
    private int tableNum;   //餐桌号
    
    @NotNull(message = "座位区域不能为NULL")
    @JSONField(name = "tableArea")
    private String tableArea;   //餐桌区域

    @JSONField(name = "food")
    private List<OrderFoodBean> food;   //菜
    
    @NotEmpty(message = "userName用户名称不能为NULL")
    @JSONField(name = "userName")
    private String userName;   //用户名

	private int userId;   //用户id

    private int seatId;   //座位id
    
    private int orderId;   //订单id
    
    private String orderCode;   //订单code

	public int getTableNum() {
		return tableNum;
	}

	public void setTableNum(int tableNum) {
		this.tableNum = tableNum;
	}

	public String getTableArea() {
		return tableArea;
	}

	public void setTableArea(String tableArea) {
		this.tableArea = tableArea;
	}

	public List<OrderFoodBean> getFood() {
		return food;
	}

	public void setFood(List<OrderFoodBean> food) {
		this.food = food;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public int getUserId() {
		return userId;
	}

	public void setUserId(int userId) {
		this.userId = userId;
	}

	public int getSeatId() {
		return seatId;
	}

	public void setSeatId(int seatId) {
		this.seatId = seatId;
	}

	public int getOrderId() {
		return orderId;
	}

	public void setOrderId(int orderId) {
		this.orderId = orderId;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

    
}
