package com.fos.modules.order.api;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.core.fetcher.FetchEntity;
import com.fos.core.fetcher.HCFetcher;
import com.fos.core.utils.GlobalUtil;
import com.fos.modules.order.bean.OrderBean;
import com.fos.modules.order.bean.OrderPrintBean;
import com.fos.modules.order.entity.OrderCoderIdEntity;
import com.fos.modules.order.service.OrderService;
import com.fos.modules.vipuser.service.VipUserService;

@Controller
@RequestMapping(value = "/api/OrderController")
public class OrderController {

	@Autowired
	private OrderService orderService;

	@Autowired
	private VipUserService vipUserService;

	@ResponseBody
	@RequestMapping(value = "/checkOrderCode")
	public ResponseBean checkOrderCode(RequestBean requestBean) {
		ResponseBean responseBean = new ResponseBean();
		OrderBean bean = requestBean.getObjectBean(OrderBean.class);
		String message = orderService.validate(bean);
		if (message == null) {
			OrderCoderIdEntity orderCoderIdEntity=orderService.Order(bean);
			Map map = new HashMap();
			
			// TODO 打印订单
			goPrint(bean);
			
			// 把新增订单放入map，显示到json
			map.put("order", orderCoderIdEntity);
			responseBean.setMessage(GConstants.OK);
			responseBean.setData(map);
			responseBean.setStatus(GConstants.STATUS_CODE_2000);
			return responseBean;
			//

		}
		responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_4001);
		return responseBean;
	}

	@ResponseBody
	@RequestMapping(value = "/getOrderPrint")
	public ResponseBean getOrderPrint(RequestBean requestBean) {
		ResponseBean responseBean = new ResponseBean();
		OrderPrintBean bean = requestBean.getObjectBean(OrderPrintBean.class);
		String message = orderService.validate(bean);
		if (message == null) {
			int num = orderService.getOrderPrint(bean);
			if (num == 0) {
				responseBean.setMessage("Print Fail");
				responseBean.setStatus(GConstants.STATUS_CODE_2001);
				return responseBean;
			} else if (num == 1) {
				responseBean.setMessage(GConstants.OK);
				responseBean.setStatus(GConstants.STATUS_CODE_2000);
				return responseBean;
			}
		}
		responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_4001);
		return responseBean;
	}
	
	private String goPrint(OrderBean bean) {

		String signKey = "&sign="+ GlobalUtil.getParamsSignStr(GConstants.SIGN_PRIVATE_KEY, bean.toString());
		String printServerUrl = GConstants.PRINT_SERVER_URL
				+ "api/PrintOrderController/orderPrint";

		HCFetcher fetcher = HCFetcher.getInstance();
		fetcher.setPolitenessDelay(3000);
		String data = "content=" + bean + signKey;
		FetchEntity entity;
		try {
			entity = fetcher.post(printServerUrl, data.getBytes("utf-8"));

			if (entity.isSuccess()) {
				return GConstants.STATUS_CODE_2000;
			} else {
				return GConstants.STATUS_CODE_2001;
			}
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return GConstants.STATUS_CODE_4001;
		}

		// fetcher.shutdown();
	}
}
