package com.fos.modules.myUserPre.api;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.RequestBean;
import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.modules.myUserPre.bean.MyUserPreBean;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkEntity;
import com.fos.modules.myUserPre.entity.MyUserPreDrinkTasteEntity;
import com.fos.modules.myUserPre.entity.MyUserPreEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodEntity;
import com.fos.modules.myUserPre.entity.MyUserPreFoodTasteEntity;
import com.fos.modules.myUserPre.service.MyUserPreService;


@Controller
@RequestMapping(value = "/api/myUserPreController")
public class MyUserPreController {

	@Autowired
	private MyUserPreService myUserPreService;
	
	
	@ResponseBody
	@RequestMapping(value = "/getMyUserPreFood")
	public ResponseBean getUserPreFood(RequestBean requestBean) {
		ResponseBean responseBean = new ResponseBean();
		MyUserPreBean myUserPreBean = requestBean.getObjectBean(MyUserPreBean.class);
		String message = myUserPreService.validate(myUserPreBean);
		if (message == null) {
			MyUserPreEntity myUserPreEntity = new MyUserPreEntity();
			// 获取该用户前3喜欢的食物
			List<MyUserPreFoodEntity> myUserPreFoodList = myUserPreService.getMyUserPreFood(myUserPreBean);
			//获取该用户前3喜欢的食物口味
			List<MyUserPreFoodTasteEntity> myUserPreFoodTasteList = myUserPreService.getMyUserPreFoodTaste(myUserPreBean);
			//获取该用户前3喜欢的喝的
			List<MyUserPreDrinkEntity> myUserPreDrinkList = myUserPreService.getMyUserPreDrink(myUserPreBean);
			//获取该用户前3喜欢的喝的口味
			List<MyUserPreDrinkTasteEntity> myUserPreDrinkTasteList = myUserPreService.getMyUserPreDrinkTaste(myUserPreBean);
			//将所有内容放入一个实体中，传给前端
			myUserPreEntity.setUserPreFoodList(myUserPreFoodList);
			myUserPreEntity.setUserPreFoodTasteList(myUserPreFoodTasteList);
			myUserPreEntity.setUserPreDrinkList(myUserPreDrinkList);
			myUserPreEntity.setUserPreDrinkTasteList(myUserPreDrinkTasteList);
			if(myUserPreEntity!=null){
				responseBean.setMessage("User Preference List");
				responseBean.setData(myUserPreEntity);
				responseBean.setStatus(GConstants.STATUS_CODE_2000);
				return responseBean;
			}
			responseBean.setMessage("Empty User Preferences");
			responseBean.setData(myUserPreEntity);
			responseBean.setStatus(GConstants.STATUS_CODE_2001);
			return responseBean;
		}
		responseBean.setMessage(message);
		responseBean.setStatus(GConstants.STATUS_CODE_4001);
		return responseBean;
	}
	
}
