package com.fos.modules.frontLog.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.fos.core.base.CurdService;
import com.fos.modules.frontLog.bean.FrontLogBean;
import com.fos.modules.frontLog.dao.FrontLogDao;
import com.fos.modules.frontLog.entity.FrontLogEntity;

@Service
public class FrontLogService extends CurdService<FrontLogDao, FrontLogEntity>{

	//获取sysUserId
  	public List<String> getUserId(String userName){
  		return dao.getUserId(userName);
  	}
  	
	 //插入新订单
  	@Transactional(readOnly = false)
  	public void addFrontLog(FrontLogBean frontLogBean){
        dao.addFrontLog(frontLogBean);
		
    }
  
  	//获取用户登录状态
  	public String getLoginStatus(String sysName){
  	    return dao.getLoginStatus(sysName);
  	}

	@Transactional(readOnly = false)
	public void changeLoginTime(String sysName){
		 dao.changeLoginTime(sysName);
	}
}
