package com.fos.demo.mybatis.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fos.core.api.ResponseBean;
import com.fos.core.conf.GConstants;
import com.fos.demo.mybatis.entity.DemoUserEntity;
import com.fos.demo.mybatis.service.DemoUserService;

@Controller
@RequestMapping(value="/demo/mybatis/user")
public class DemoUserController {

    @Autowired
    DemoUserService demoUserService;
    
    @ResponseBody
    @RequestMapping(value="/get")
    public DemoUserEntity getUser(){
        
        return demoUserService.getUser();
    }
    
    @ResponseBody
    @RequestMapping(value="/find/id")
    public DemoUserEntity findById(@RequestParam(value="id", required=true) Long id){
        
        return demoUserService.findById(id);
    }
}
