package com.fos.demo.mybatis.service;


import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.fos.core.base.CurdService;
import com.fos.core.base.FindEntity;
import com.fos.demo.mybatis.dao.DemoUserDao;
import com.fos.demo.mybatis.entity.DemoUserEntity;

@Service
@Transactional(readOnly = true)
public class DemoUserService extends CurdService<DemoUserDao, DemoUserEntity>{
    
    @Transactional(readOnly=true)
    public DemoUserEntity getUser(){
        return dao.get(null);
    }
    
    @Override
    @Transactional(readOnly=true)
    @Cacheable(value = "userCache", key="#id")
    public DemoUserEntity findById(Long id){
    
        FindEntity entity = new FindEntity(id);
        return dao.findById(entity);
    }
    
    /*public Page finds(DemoUserEntity entity){
        PageHelper.startPage(6, 2);
        List<DemoUserEntity> list=dao.findList(entity);
        PageInfo pageinfo=new PageInfo(list);
        Page<DemoUserEntity> page=new Page<DemoUserEntity>();
        page.addAll(list);
        page.setPageNum(pageinfo.getPageNum());
        page.setPageSize(pageinfo.getPageSize());
        page.setPages(pageinfo.getPages());
        return page;
    }*/
    
}
