package com.fos.core.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.fos.core.conf.GConstants;

/**
 * IP 白名单工具类，也验证IP是否有效，支持分段IP和通配符IP*
 *
 */
public class IPWhiteList {

    private static final Set<String> IP_ITEMS = new HashSet<String>(10);
    // 是否验证授权IP地址
    public static final boolean      IS_VERIFY_IP = GConstants.getBoolean("is.verify.client.ip", false);
    
    public static final IPWhiteList IPWHITELIST = new IPWhiteList();
    
    private IPWhiteList(){
        // 导入IP限制列表
        if (IS_VERIFY_IP) {
            IPWhiteList.add(GConstants.getValue("client.ip.white.list"));
        }
    }
    /**
     * 添加一个白名单IP，多个IP地址以分号分隔，支持分段IP及*通配符匹配，127.0.1.1-255;127.0.1.*;127.0.1.1;<br/>
     * 127.0.1.1-255 == 127.0.1.1/255<br/>
     * 127.0.1-6.1-255 == 127.0.1/6.1/255<br/>
     * 127.0.*.* == 127.0.* == 127.0<br/>
     * @param ip
     */
    public static void add(String clients){
        if(clients != null && clients.length() != 0){
            String[] patternList = clients.split(GConstants.SEMICOLON);
            for (String ip : patternList) {
                if(ip.trim().length() != 0){
                    IP_ITEMS.add(ip.trim());
                }
           }
        }
    }
    /**
     * 验证IP是否在白名单内
     * @param ip
     * @return
     */
    public static boolean verify(String ip) {
        if(!IS_VERIFY_IP || IP_ITEMS.isEmpty())
            return true;
        if(ip == null || ip.length() == 0)
            return false;
        if(IP_ITEMS.contains(ip))
            return true;
        Iterator<String> iterator= IP_ITEMS.iterator();
        while (iterator.hasNext()) {
            String pattern = iterator.next();
//            System.out.println("pattern:"+pattern);
            if(verify(ip, pattern)){
                return true;
            }
        }
        return false;
    }
    /**
     * 验证IP是否在和指定IP匹配
     * @param ip
     * @param pattern
     * @return
     */
    public static boolean verify(String ip, String pattern) {
        
        if(ip == null || pattern == null || ip.length() == 0 || pattern.length() == 0)
            return false;
        String[] ips = ip.split("\\.");
        String[] patterns = pattern.split("\\.");
        // 也patterns的个数为
        if(patterns.length>ips.length)
            return false;
        for (int i = 0, len = patterns.length; i < len; i++) {
            if(patterns[i].contains("-")){// 分段IP验证
                String[] species = patterns[i].split("-");
                int a = Integer.parseInt(species[0]);
                int b = Integer.parseInt(species[1]);
                int c = Integer.parseInt(ips[i]);
                if(c<a || c>b)
                    return false;
            } else if(patterns[i].contains("/")){// 分段IP验证
                String[] species = patterns[i].split("/");
                int a = Integer.parseInt(species[0]);
                int b = Integer.parseInt(species[1]);
                int c = Integer.parseInt(ips[i]);
                if(c<a || c>b)
                    return false;
            } else if(!ips[i].equals(patterns[i]) && !"*".equals(patterns[i])){// 及不是分隔符。也不是通配符则需要判断是否相等
                return false;
            }
        }
        return true;
    }
}
