package com.fos.core.security;

import java.net.URLDecoder;
import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class DESUtils {

    public static final String  ALGORITHM = "DES";
    private static final String HMAC_SHA1 = "HmacSHA1";
    /**
     * DES 解密
     * @param data
     * @param key
     * @return
     */
    public static byte[] decrypt(byte[] data, String key) {
        try {
            byte[] keyBytes = Base64Util.decode(key);
            DESKeySpec dks = new DESKeySpec(keyBytes);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            Key secretKey = keyFactory.generateSecret(dks);
            
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, secretKey);

            return cipher.doFinal(data);
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return null;
    }
    /**
     * DES 加密
     * @param data
     * @param key
     * @return
     */
    public static byte[] encrypt(byte[] data, String key) {
        try {
            byte[] keyBytes = Base64Util.decode(key);
            DESKeySpec dks = new DESKeySpec(keyBytes);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            Key secretKey = keyFactory.generateSecret(dks);
            
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);

            return cipher.doFinal(data);
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        return null;
    }
    /**
     * HmacSHA1 生成签名
     * @param data
     * @param privateKey
     * @return
     */
    public static String sign(byte[] data, String privateKey) {

        byte[] rawHmac = null;
        try {
            byte[] keyBytes = Base64Util.decode(privateKey);
            if(keyBytes == null)
                return null;
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1);
            Mac mac = Mac.getInstance(HMAC_SHA1);

            mac.init(signingKey);
            rawHmac = mac.doFinal(data);
            return Base64Util.encode(rawHmac);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    /**
     * HmacSHA1 签名验证
     * @param data
     * @param privateKey
     * @param sign
     * @return
     */
    public static boolean verify(byte[] data, String privateKey, String sign) {
        try {
            String mSign = sign(data, privateKey);
            if(mSign == null || sign == null)
                return true;
            mSign = URLDecoder.decode(mSign, "UTF-8");
            return mSign.equals(sign);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return false;
    }
}
