package com.fos.core.conf;

import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

/**
 * 全局常量表
 * @author Administrator
 *
 */
public class GConstants {
    
    private static Logger LOG = Logger.getLogger(GConstants.class);
    
    // 常用系统属性
    public static final String   LS = System.getProperty("line.separator");// 文本换行符
    public static final String   FS = "/";//System.getProperty("file.separator");// 文件分隔符
    public static final int      BUFFER_SIZE = 8192;// 新建BYTE缓存大小，8*1024;
    public static final String   SEMICOLON   = ";";// 分号
    
    public static String  FILE_PATH_PREFIX       = "2016";// 临时文件地址
    // 文件过滤，
    public final static  Map<String, Boolean> FILE_FILTERS = new HashMap<String, Boolean>(10);
    private static final Properties P = new Properties();// 属性变
    public static final  GConstants C = new GConstants();// 单实体类
    
    // 错误码前缀说明 20 - 服务器成功返回 40 - 一般性错误 50 - 服务不可用，系统错误 STATUS
    // 成功
    public static final String STATUS_CODE_2000 = "2000";// 成功
    public static final String STATUS_CODE_2001 = "2001";// 查询列表为空

    //用户名密码
    public static final String STATUS_CODE_3001 = "3001";// 用户名或密码错误
    public static final String STATUS_CODE_3002 = "3002";// 用户名不存在
    
    // 服务器错误
    public static final String STATUS_CODE_5001 = "5001";// 数据库错误
    public static final String STATUS_CODE_5002 = "5002";// Java异常
    public static final String STATUS_CODE_5003 = "5003";// 系统出错
    
    // 数据错误表
    public static final String STATUS_CODE_4001 = "4001";// 数据不能为空，数据验证不通过
    public static final String STATUS_CODE_4002 = "4002";// 查询不存在：如用户不存在、商品部存在等
    
    // 活动抽奖模块
    public static final String ACTIVITY_CODE_80000 = "80000";// 中奖
    public static final String ACTIVITY_CODE_80001 = "80001";// 未中奖
    public static final String ACTIVITY_CODE_80002 = "80002";// 奖品已发完
    public static final String ACTIVITY_CODE_80003 = "80003";// 活动未开始
    public static final String ACTIVITY_CODE_80004 = "80004";// 活动进行中
    public static final String ACTIVITY_CODE_80005 = "80005";// 活动已结束
    public static final String ACTIVITY_CODE_80006 = "80006";// 已中奖
    public static final String ACTIVITY_CODE_80007 = "80007";// 已经中了3次
    
    public static final String ACTIVITY_CODE_80008 = "80008";// 中奖次数达到上限
    public static final String ACTIVITY_CODE_80009 = "80009";// 抽奖次数达到上限
    
    
    public static final String COUPONS_CODE_60001 = "60001";// 创新卷不存在
    public static final String COUPONS_CODE_60002 = "60002";// 创新卷已绑定！
    public static final String COUPONS_CODE_60003 = "60003";// 创新卷已经失效
    public static final String COUPONS_CODE_60004 = "60004";// 创新卷密码不匹配
    public static final String COUPONS_CODE_60005 = "60005";// 创新卷余额不足
    
    public static final String VERIFY_CODE_90000 = "90000";// 验证码已使用
    public static final String VERIFY_CODE_90001 = "90001";// 验证码已使用
    public static final String VERIFY_CODE_90002 = "90002";// 验证码过期
    public static final String VERIFY_CODE_90003 = "90003";// 验证码错误
    public static final String VERIFY_CODE_90005 = "90005";// 点后已经存在
    
    public static final String VERIFY_MESSAGE_90000 = "未生成验证码";// 验证码错误
    public static final String VERIFY_MESSAGE_90001 = "验证码已使用";// 验证码已使用
    public static final String VERIFY_MESSAGE_90002 = "验证码过期";// 验证码过期
    public static final String VERIFY_MESSAGE_90003 = "验证码错误";// 验证码错误
    
    public static final String ORDER_CODE_61000 = "61000";// 待签订合同
    public static final String ORDER_CODE_61001 = "61001";// 待审核订单
    public static final String ORDER_CODE_61002 = "61002";// 待上传合同
    public static final String ORDER_CODE_61003 = "61003";// 待审核合同
    public static final String ORDER_CODE_61004 = "61004";// 待支付
    public static final String ORDER_CODE_61005 = "61005";// 服务中
    public static final String ORDER_CODE_61006 = "61006";// 待评价
    public static final String ORDER_CODE_61007 = "61007";// 订单已完成
    public static final String ORDER_CODE_61008 = "61008";// 订单已取消
    public static final String ORDER_CODE_61009 = "61009";// 订单删除
    public static final String ORDER_CODE_61010 = "61010";// 预约订单
    
    public static final String ORDER_TYPE_OP  = "OP";// 商品类型 OP 普通订单 OCP 创新券订单
    public static final String ORDER_TYPE_OCP = "OCP";// 商品类型 OP 普通订单 OCP 创新券订单
    
    public static final String PRODUCT_TYPE_IS = "IS";// 商品类型 S 普通商品 IS 创新券商品
    public static final String PRODUCT_TYPE_S = "S";//  商品类型 S 普通商品 IS 创新券商品
    
    // private String fileType = "UF";// 文件类型 UF Unknown其它文件类型 CF Contract合同 PF Pay付款凭证 MF  Material证明材料
    public static final String FILE_TYPE_CF = "CF";// CF Contract合同 
    public static final String FILE_TYPE_PF = "PF";// PF Pay付款凭证
    public static final String FILE_TYPE_MF = "MF";// MF  Material证明材料
    public static final String FILE_TYPE_UF = "UF";// MF  Material证明材料
    public static final String FILE_TYPE_REGIST = "REGIST";// 公司注册文件
    
    public static final String CONTACT_TYPE_WORKSHOP = "W";// 空间类型
    public static final String CONTACT_TYPE_SERVICE = "S";// 服务类型
    
    public static final String CONTACT_STATUS_62000 = "62000";// 状态 62000 未处理 62001 客户已转化 62002 客户已流失
    public static final String CONTACT_STATUS_62001 = "62001";// 62001 客户已转化
    public static final String CONTACT_STATUS_62002 = "62002";// 62002 客户已流失
    
    public static final String PAY_STATUS_SUCCESS = "SUCCESS";// 待签订合同
    public static final String PAY_STATUS_WAIT    = "WAIT";// 待审核订单
    // 是|否
    public static final String YES = "1";
    public static final String NO  = "0";
    public static final String OK  = "OK";
    
    public static final String  SIGN_PRIVATE_KEY        = GConstants.getValue("content.sign.private.key", "FvNMhdkN5eTsgAfU2YHGJ2RfpKVi3omn");// 签名私钥
    public static final boolean IS_VERIFY_CONTENT_SIGN  = GConstants.getBoolean("is.verify.content.sign", false);// 是否验证签名
    
    // 将基本配置导入为固定常量
    public static final String  SERVER_HTTP_URL    = GConstants.getValue("server.http.url");// 服务器HTTP基本地址，必须也反斜杠结尾
    public static final String  SERVER_HTTPS_URL   = GConstants.getValue("server.https.url");// 服务器HTTPS基本地址，必须也反斜杠结尾
    public static final String  SERVER_IP_URL      = GConstants.getValue("server.ip.url");// 服务器IP基本地址，必须也反斜杠结尾
    
    public static final String  WAP_PAY_RETURN_URL = GConstants.getValue("wap.pay.return.url");// WAP支付PHP回调地址
    public static final String  PUSH_SERVER_URL    = GConstants.getValue("push.server.url");// 推送服务器地址
    
    public static final String  FILE_UPLOAD_DIR    = GConstants.getValue("file.upload.dir");// 文件上传地址
    public static final String  FILE_PREFIX_URL    = GConstants.getValue("file.prefix.url");// 文件读取URL前缀
    public static final String  FILE_TMP_DIR       = FILE_UPLOAD_DIR+"tmp";// 临时文件地址
    public static final String  FILE_IMAGE_THUMBS  = "thumbs";// 缩略图文件顶级路径名称 201605/thumbs/images/user/png/0d7ed36548c9ea6586363d4de5cb322c.png
    public static final String  FILE_IMAGE_ACTUALS = "actuals";// 原图文件顶级路径名称  201605/actuals/images/user/png/0d7ed36548c9ea6586363d4de5cb322c.png
    public static final boolean FILE_ALLOW_THUMBS  = GConstants.getBoolean("file.image.thumb.is.allow", true);
    
    public static final int     PAGE_SIZE          = GConstants.getIntValue("page.size", 20);// 默认分页条数，默认10条
    public static final int     MAX_UPLOAD_SIZE    = GConstants.getIntValue("file.max.upload.size", 10485760);// 允许最多上传文件大小，默认10M
    // 是否开启手机视图拦截器
    public static final boolean IS_MOBILE_INTERCEPTOR  = GConstants.getBoolean("is.mobile.interceptor", true);
    
    public static final String  DEFAULT_USER_ROLE_CODE      = GConstants.getValue("default.user.role.code", "_USER");// 默认用户角色
    
    public static final String  DEFAULT_USER_AVATAR      = GConstants.getValue("user.default.avatar", "");// 默认用户角色
    
    public static final String  PRINT_SERVER_URL = GConstants.getValue("print.server.url");// 默认打印机服务URL
    
    public static final String  PRINTER_NAME_FOOD = GConstants.getValue("printer.name.food");// 默认打印机名称-食物
    
    public static final String  PRINTER_NAME_DRINK = GConstants.getValue("printer.name.drink");// 默认打印机名称-饮料

    public static final String  PRINTER_NAME_NOODLE = GConstants.getValue("printer.name.noodle");// 默认打印机名称-食物
    private GConstants(){
        // 加载基本配置文件
        InputStream is = null;
        ResourceLoader resourceLoader = null;
        Resource resource = null;
        try {
            resourceLoader = new DefaultResourceLoader();
            resource = resourceLoader.getResource("fos.properties");
            is = resource.getInputStream();
            P.load(is);
            
            LOG.debug("加载fos.properties成功");
        } catch (Exception e) {
            LOG.info("加载fos.properties失败", e);
        } finally {
            IOUtils.closeQuietly(is);
        }
        // 加载数据库配置文件
        try {
            resourceLoader = new DefaultResourceLoader();
            resource = resourceLoader.getResource("jdbc.properties");
            is = resource.getInputStream();
            P.load(is);
            
            LOG.debug("加载jdbc.properties成功");
        } catch (Exception e) {
            LOG.info("加载jdbc.properties失败", e);
        } finally {
            IOUtils.closeQuietly(is);
        }
        try {
            // 上传文件扩展名称限制
            String extensions = GConstants.getValue("file.allow.extensions");
            if(extensions != null && extensions.contains(SEMICOLON)){
                if(extensions.length() != 0){
                    String[] patternList = extensions.split(SEMICOLON);
                    for (String ext : patternList) {
                        if(ext.trim().length() != 0){
                            FILE_FILTERS.put(ext.trim(), false);
                        }
                   }
                }
            }
            // 图片后缀文件
            extensions = GConstants.getValue("file.image.extensions");
            if(extensions != null && extensions.contains(SEMICOLON)){
                if(extensions.length() != 0){
                    String[] patternList = extensions.split(SEMICOLON);
                    for (String ext : patternList) {
                        if(ext.trim().length() != 0){
                            FILE_FILTERS.put(ext.trim(), true);
                        }
                   }
                }
            }
            // 临时文件夹路径
            if(P.getProperty("file.upload.dir") != null){
                File tmp = new File(P.getProperty("file.upload.dir")+"tmp");
                if(!tmp.exists())
                    tmp.mkdirs();
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        try {
            if(StringUtils.isBlank(GConstants.getValue("file.path.format")) == false){
                try {
                    SimpleDateFormat PRE_FORMAT = new SimpleDateFormat(GConstants.getValue("file.prefix.filename.format"));
                    GConstants.FILE_PATH_PREFIX = PRE_FORMAT.format(System.currentTimeMillis());// 文件名称前面部分
                } catch (Exception e) {
                    SimpleDateFormat PRE_FORMAT = new SimpleDateFormat("yyyyMM");
                    GConstants.FILE_PATH_PREFIX = PRE_FORMAT.format(System.currentTimeMillis());// 文件名称前面部分
                }
            } else {
                SimpleDateFormat PRE_FORMAT = new SimpleDateFormat("yyyyMM");
                GConstants.FILE_PATH_PREFIX = PRE_FORMAT.format(System.currentTimeMillis());// 文件名称前面部分
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
        }
        
    }
    
    /**
     * 获取属性，以自定义属性优先，然后回去系统属性
     * @param key
     * @return
     */
    public static String getValue(String key) {
        if(key == null)
            return null;
        if (P.containsKey(key)) {
            return P.getProperty(key);
        }
        return System.getProperty(key);
    }
    public static String getValue(String key, String want) {
        String val = getValue(key);
        if(val == null)
            return want;
        return val;
    }
    /**
     * 解析为Boolean类型
     * @param key
     * @param want
     * @return
     */
    public static boolean getBoolean(String key, boolean want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Boolean.parseBoolean(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    /**
     * 获取整型数据，转换数据类型
     * @param key
     * @param want
     * @return
     */
    public static int getIntValue(String key, int want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Integer.parseInt(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    /**
     * 获取长整型数据
     * @param key
     * @param want
     * @return
     */
    public static long getLongValue(String key, long want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Long.parseLong(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    public static float getFloatValue(String key, float want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Float.parseFloat(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
    public static double getDoubleValue(String key, double want) {
        String val = getValue(key);
        if(val == null || val.length() == 0)
            return want;
        try {
            return Double.parseDouble(val);
        } catch (Exception e) {
            // TODO: handle exception
        }
        return want;
    }
}
