package com.fos.core.base;

import java.util.List;

import javax.validation.constraints.Min;

import com.alibaba.fastjson.annotation.JSONField;
import com.fos.core.conf.GConstants;

/**
 * @team BBDTEK Dev Team
 * @version 1.0
 * @time 2016-03-10
 * 
 * @param <T>
 */
public final class PageEntity<T> extends BaseEntity{

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    
    @Min(value=1, message="page_no必须大于等于1")
    @JSONField(name="page_no")
    private int pageNo=1;//第几页
    
    @Min(value=1, message="page_size必须大于等于1")
    @JSONField(name="page_size")
    private int pageSize=GConstants.PAGE_SIZE;//每页条数
    
    @JSONField(name="total_page")
    private int totalPage;//总页数
    private long count;//总条数
    private List<T> list; 
    

    public PageEntity() {
        super();
    }
    public PageEntity(int pageNo, int pageSize) {
        super();
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }
    public List<T> getList() {
        return list;
    }
    public void setList(List<T> list) {
        this.list = list;
    }
    public int getPageNo() {
        return pageNo;
    }
    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }
    public int getPageSize() {
        return pageSize;
    }
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
    public int getTotalPage() {
        return totalPage;
    }
    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }
    public long getCount() {
        return count;
    }
    public void setCount(long count) {
        this.count = count;
    }

}
