package com.fos.core.base;

import org.hibernate.validator.constraints.NotEmpty;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fos.core.conf.GConstants;

/**
 * 
 * 请求接口基本数据
 * @team BBDTEK Dev Team
 * @version 1.0
 * @time 2016-03-10
 *
 */
public abstract class GenericBean extends BaseBean{

    @NotEmpty(message="role_code不允许为空")
    @JSONField(name="role_code")
    protected String roleCode = GConstants.DEFAULT_USER_ROLE_CODE;//用户角色code
    
    @NotEmpty(message="version_name不允许为空")
    @JSONField(name="version_name")
    protected String versionName;// 用户渠道

    @NotEmpty(message="platform不允许为空")
    @JSONField(name="platform")
    protected String platform;// 用户渠道
    
    @JSONField(name="deviceid")
    protected String deviceid;// 用户渠道
    
    @JSONField(name="device_token")
    protected String deviceToken;// 用户渠道
    
    @JSONField(name="lat")
    protected String latitude;// 纬度
    
    @JSONField(name="lng")
    protected String longitude;// 经度
    
    @JSONField(name="address")
    protected String address;// 地区格式化名称
    
    @JSONField(name="module_name")
    protected String moduleName;// 设备名称
    
    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getVersionName() {
        return versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getDeviceid() {
        return deviceid;
    }

    public void setDeviceid(String deviceid) {
        this.deviceid = deviceid;
    }

    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getModuleName() {
        return moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
    
}
