package com.fos.core.base;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

/**
 * Service基类
 * @team BBDTEK Dev Team
 * @version 1.0
 * @time 2016-03-10
 */
@Transactional(readOnly = true)
public abstract class CurdService <D extends CurdDao<T>, T extends BaseEntity> 
                extends BaseService<D>{
    /**
     * 获取单条数据
     * @param entity
     * @return
     */
    public T get(T entity){
        return dao.get(entity);
    }
    /**
     * 获取单条数据
     * @param id
     * @return
     */
    public T findById(Long id){
        FindEntity entity = new FindEntity(id);
        return dao.findById(entity);
    }
    /**
     * 获取单条数据
     * @param id
     * @return
     */
    public T findByCode(String code){
        FindEntity entity = new FindEntity(code);
        return dao.findByCode(entity);
    }
    /**
     * 查询数据列表，如果需要分页，请设置分页对象，如：entity.setPage(new Page<T>());
     * @param entity
     * @return
     */
    public List<T> findList(T entity){
        return dao.findList(entity);
    }
    
    
    /**
     * 查询数据列表，如果需要分页，请设置分页对象，如：entity.setPage(new Page<T>());
     * @param entity
     * @return
     */
    public List<T> findListByCode(String code){
        FindEntity entity = new FindEntity(code);
        return dao.findListByCode(entity);
    }
    
    /**
     * 查询所有数据列表
     * @param entity
     * @return
     */
    public List<T> findAllList(T entity){
        return dao.findAllList(entity);
    }
    
    /**
     * 插入数据
     * @param entity
     * @return 返回查询数据行数
     */
    @Transactional(readOnly = false)
    public void insert(T entity){
        dao.insert(entity);
    }
    
    /**
     * 更新数据
     * @param entity
     * @return 影响行数
     */
    @Transactional(readOnly = false)
    public int update(T entity){
        return dao.update(entity);
    }
    
    /**
     * 删除数据（一般为逻辑删除，更新del_flag字段为1）
     * @param entity
     * @return 影响行数
     */
    @Transactional(readOnly = false)
    public int delete(T entity){
        return dao.delete(entity);
    }
    
    /**
     * 删除数据（一般为逻辑删除，更新del_flag字段为1）
     * @param entity
     * @return 影响行数
     */
    @Transactional(readOnly = false)
    public int deleteById(Long id){
        FindEntity entity = new FindEntity(id);
        return dao.deleteById(entity);
    }
    
    /**
     * 删除数据（一般为逻辑删除，更新del_flag字段为1）
     * @param entity
     * @return 影响行数
     */
    @Transactional(readOnly = false)
    public int deleteByCode(String code){
        FindEntity entity = new FindEntity(code);
        return dao.deleteByCode(entity);
    }
    
    /**
     * 查询分页数据
     * @param page 分页对象
     * @param entity
     * @return
     */
    public PageEntity<T> findPageList(PageEntity<T> page, T entity) {
        PageHelper.startPage(page.getPageNo(), page.getPageSize());
        PageInfo<T> pageInfo=new PageInfo<T>(dao.findList(entity));
        if(pageInfo.getPages()<page.getPageNo()){
            
            return null;
        }
        page.setPageNo(pageInfo.getPageNum());
        page.setPageSize(pageInfo.getPageSize());
        page.setCount(pageInfo.getTotal());
        page.setTotalPage(pageInfo.getPages());
        page.setList(pageInfo.getList());
        return page;
    }

    /**
     * 查询分页数据
     * @param page 分页对象
     * @param entity
     * @return
     */
    public PageEntity<T> findPageList(int pageNo,int pageSize, T entity) {
        PageHelper.startPage(pageNo,pageSize);
        PageInfo<T> pageInfo=new PageInfo<T>(dao.findList(entity));
        if(pageInfo.getPages()<pageNo){
            
            return null;
        }
        PageEntity<T> page=new PageEntity<T>();
        page.setPageNo(pageInfo.getPageNum());
        page.setPageSize(pageInfo.getPageSize());
        page.setCount(pageInfo.getTotal());
        page.setTotalPage(pageInfo.getPages());
        page.setList(pageInfo.getList());
        return page;
    }
}
