package com.fos.core.base;

import java.util.List;

/**
 * @team BBDTEK Dev Team
 * @version 1.0
 * @time 2016-03-10
 */
public interface CurdDao<T> extends BaseDao{
    /**
     * 获取单条数据
     * @param entity
     * @return
     */
    public T get(T entity);
    /**
     * 获取单条数据
     * @param id
     * @return
     */
    public T findById(FindEntity entity);
    /**
     * 获取单条数据
     * @param id
     * @return
     */
    public T findByCode(FindEntity entity);
    /**
     * 查询数据列表，如果需要分页，请设置分页对象，如：entity.setPage(new Page<T>());
     * @param entity
     * @return
     */
    public List<T> findList(T entity);
    
    
    /**
     * 查询数据列表，如果需要分页，请设置分页对象，如：entity.setPage(new Page<T>());
     * @param entity
     * @return
     */
    public List<T> findListByCode(FindEntity entity);
    
    /**
     * 查询所有数据列表
     * @param entity
     * @return
     */
    public List<T> findAllList(T entity);
    
    /**
     * 插入数据
     * @param entity
     * @return 返回查询数据行数
     */
    public void insert(T entity);
    
    /**
     * 更新数据
     * @param entity
     * @return 影响行数
     */
    public int update(T entity);
    
    /**
     * 删除数据（一般为逻辑删除，更新del_flag字段为1）
     * @param entity
     * @return 影响行数
     */
    public int delete(T entity);
    
    /**
     * 删除数据（一般为逻辑删除，更新del_flag字段为1）
     * @param entity
     * @return 影响行数
     */
    public int deleteById(FindEntity entity);
    
    /**
     * 删除数据（一般为逻辑删除，更新del_flag字段为1）
     * @param entity
     * @return 影响行数
     */
    public int deleteByCode(FindEntity entity);
}
