package com.fos.core.base;

import org.hibernate.validator.constraints.NotEmpty;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fos.core.conf.GConstants;

import javax.validation.constraints.NotNull;

/**
 * 
 * 请求接口基本数据
 * @team BBDTEK Dev Team
 * @version 1.0
 * @time 2016-03-10
 *
 */
public class BaseBean {
    
    @NotEmpty(message="app_code不允许为空")
    @JSONField(name="app_code")
    protected String appCode;       //渠道号

    @NotNull(message = "sys_name不能为NULL")
    @JSONField(name="sys_name")
    protected String sysName;
    
    @JSONField(name="appkey")
    protected String appkey;

    @JSONField(name="version_name")
    protected String version;      // app版本

    @JSONField(name="device_token")
    protected String deviceToken;       //手机推送TOKEN

    @JSONField(name="module_name")
    protected String moduleName;        //设备名称

    @JSONField(name="platform")
    protected String platform;      //平台

    @JSONField(name="language")
    protected String language;      //语言

    @JSONField(name="deviceid")
    protected String deviceId;          //手机设备ID

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDeviceToken() {
        return deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public String getSysName() {
		return sysName;
	}
	public void setSysName(String sysName) {
		this.sysName = sysName;
	}
	public String getAppCode() {
        return appCode;
    }
    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }
    public String getAppkey() {
        return appkey;
    }
    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getModuleName() {
        return moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
