/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.UrlBasedViewResolverRegistration;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer;
import org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;
import org.springframework.web.servlet.view.script.ScriptTemplateConfigurer;
import org.springframework.web.servlet.view.script.ScriptTemplateViewResolver;
import org.springframework.web.servlet.view.tiles3.TilesConfigurer;
import org.springframework.web.servlet.view.tiles3.TilesViewResolver;
import org.springframework.web.servlet.view.velocity.VelocityConfigurer;
import org.springframework.web.servlet.view.velocity.VelocityViewResolver;

public class ViewResolverRegistry {
    private ContentNegotiatingViewResolver contentNegotiatingResolver;
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(4);
    private Integer order;
    private ContentNegotiationManager contentNegotiationManager;
    private ApplicationContext applicationContext;

    protected void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    protected void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean hasRegistrations() {
        return this.contentNegotiatingResolver != null || !this.viewResolvers.isEmpty();
    }

    public void enableContentNegotiation(View ... defaultViews) {
        this.initContentNegotiatingViewResolver(defaultViews);
    }

    public void enableContentNegotiation(boolean useNotAcceptableStatus, View ... defaultViews) {
        this.initContentNegotiatingViewResolver(defaultViews);
        this.contentNegotiatingResolver.setUseNotAcceptableStatusCode(useNotAcceptableStatus);
    }

    private void initContentNegotiatingViewResolver(View[] defaultViews) {
        this.order = this.order == null ? Integer.MIN_VALUE : this.order;
        if (this.contentNegotiatingResolver != null) {
            if (!ObjectUtils.isEmpty((Object[])defaultViews) && !CollectionUtils.isEmpty(this.contentNegotiatingResolver.getDefaultViews())) {
                ArrayList<View> views = new ArrayList<View>(this.contentNegotiatingResolver.getDefaultViews());
                views.addAll(Arrays.asList(defaultViews));
                this.contentNegotiatingResolver.setDefaultViews(views);
            }
        } else {
            this.contentNegotiatingResolver = new ContentNegotiatingViewResolver();
            this.contentNegotiatingResolver.setDefaultViews(Arrays.asList(defaultViews));
            this.contentNegotiatingResolver.setViewResolvers(this.viewResolvers);
            this.contentNegotiatingResolver.setContentNegotiationManager(this.contentNegotiationManager);
        }
    }

    public UrlBasedViewResolverRegistration jsp() {
        return this.jsp("/WEB-INF/", ".jsp");
    }

    public UrlBasedViewResolverRegistration jsp(String prefix, String suffix) {
        InternalResourceViewResolver resolver = new InternalResourceViewResolver();
        resolver.setPrefix(prefix);
        resolver.setSuffix(suffix);
        this.viewResolvers.add(resolver);
        return new UrlBasedViewResolverRegistration(resolver);
    }

    public UrlBasedViewResolverRegistration tiles() {
        if (this.applicationContext != null && !this.hasBeanOfType(TilesConfigurer.class)) {
            throw new BeanInitializationException("In addition to a Tiles view resolver there must also be a single TilesConfigurer bean in this web application context (or its parent).");
        }
        TilesRegistration registration = new TilesRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration freeMarker() {
        if (this.applicationContext != null && !this.hasBeanOfType(FreeMarkerConfigurer.class)) {
            throw new BeanInitializationException("In addition to a FreeMarker view resolver there must also be a single FreeMarkerConfig bean in this web application context (or its parent): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.");
        }
        FreeMarkerRegistration registration = new FreeMarkerRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration velocity() {
        if (this.applicationContext != null && !this.hasBeanOfType(VelocityConfigurer.class)) {
            throw new BeanInitializationException("In addition to a Velocity view resolver there must also be a single VelocityConfig bean in this web application context (or its parent): VelocityConfigurer is the usual implementation. This bean may be given any name.");
        }
        VelocityRegistration registration = new VelocityRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration groovy() {
        if (this.applicationContext != null && !this.hasBeanOfType(GroovyMarkupConfigurer.class)) {
            throw new BeanInitializationException("In addition to a Groovy markup view resolver there must also be a single GroovyMarkupConfig bean in this web application context (or its parent): GroovyMarkupConfigurer is the usual implementation. This bean may be given any name.");
        }
        GroovyMarkupRegistration registration = new GroovyMarkupRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public UrlBasedViewResolverRegistration scriptTemplate() {
        if (this.applicationContext != null && !this.hasBeanOfType(ScriptTemplateConfigurer.class)) {
            throw new BeanInitializationException("In addition to a script template view resolver there must also be a single ScriptTemplateConfig bean in this web application context (or its parent): ScriptTemplateConfigurer is the usual implementation. This bean may be given any name.");
        }
        ScriptRegistration registration = new ScriptRegistration();
        this.viewResolvers.add(registration.getViewResolver());
        return registration;
    }

    public void beanName() {
        BeanNameViewResolver resolver = new BeanNameViewResolver();
        this.viewResolvers.add(resolver);
    }

    public void viewResolver(ViewResolver viewResolver) {
        if (viewResolver instanceof ContentNegotiatingViewResolver) {
            throw new BeanInitializationException("addViewResolver cannot be used to configure a ContentNegotiatingViewResolver. Please use the method enableContentNegotiation instead.");
        }
        this.viewResolvers.add(viewResolver);
    }

    public void order(int order) {
        this.order = order;
    }

    protected boolean hasBeanOfType(Class<?> beanType) {
        return !ObjectUtils.isEmpty((Object[])BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, beanType, (boolean)false, (boolean)false));
    }

    protected int getOrder() {
        return this.order != null ? this.order : Integer.MAX_VALUE;
    }

    protected List<ViewResolver> getViewResolvers() {
        if (this.contentNegotiatingResolver != null) {
            return Collections.singletonList(this.contentNegotiatingResolver);
        }
        return this.viewResolvers;
    }

    private static class ScriptRegistration
    extends UrlBasedViewResolverRegistration {
        private ScriptRegistration() {
            super(new ScriptTemplateViewResolver());
            this.getViewResolver();
        }
    }

    private static class GroovyMarkupRegistration
    extends UrlBasedViewResolverRegistration {
        private GroovyMarkupRegistration() {
            super(new GroovyMarkupViewResolver());
            this.getViewResolver().setSuffix(".tpl");
        }
    }

    private static class FreeMarkerRegistration
    extends UrlBasedViewResolverRegistration {
        private FreeMarkerRegistration() {
            super(new FreeMarkerViewResolver());
            this.getViewResolver().setSuffix(".ftl");
        }
    }

    private static class VelocityRegistration
    extends UrlBasedViewResolverRegistration {
        private VelocityRegistration() {
            super(new VelocityViewResolver());
            this.getViewResolver().setSuffix(".vm");
        }
    }

    private static class TilesRegistration
    extends UrlBasedViewResolverRegistration {
        private TilesRegistration() {
            super(new TilesViewResolver());
        }
    }
}

