/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.cookie;

import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.cookie.ClientCookie;
import ytx.org.apache.http.cookie.Cookie;
import ytx.org.apache.http.cookie.CookieAttributeHandler;
import ytx.org.apache.http.cookie.CookieOrigin;
import ytx.org.apache.http.cookie.CookieRestrictionViolationException;
import ytx.org.apache.http.cookie.MalformedCookieException;
import ytx.org.apache.http.cookie.SetCookie;
import ytx.org.apache.http.cookie.SetCookie2;

@Immutable
public class RFC2965VersionAttributeHandler
implements CookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }
}

