/*
 * Decompiled with CFR 0.152.
 */
package org.geo.split;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.geo.split.PostfixNode;

public class RegionNode {
    private String regionPrefix;
    private List<PostfixNode> suffixes = new ArrayList<PostfixNode>();

    public RegionNode() {
    }

    public RegionNode(String region) {
        this.regionPrefix = region;
    }

    public String getRegionPrefix() {
        return this.regionPrefix;
    }

    public void setRegionPrefix(String regionPrefix) {
        this.regionPrefix = regionPrefix;
    }

    public List<PostfixNode> getSuffixes() {
        return this.suffixes;
    }

    public void setSuffixes(List<PostfixNode> suffixes) {
        this.suffixes = suffixes;
    }

    public void addSuffixes(PostfixNode node, String postcode) {
        boolean seened = false;
        for (PostfixNode suffix : this.getSuffixes()) {
            if (!suffix.equals(node)) continue;
            if (postcode != null && !postcode.equals(suffix.getPostcode())) {
                suffix.setPostcode(postcode);
            }
            seened = true;
        }
        if (!seened) {
            this.suffixes.add(node);
        }
        Collections.sort(this.suffixes, new Comparator<PostfixNode>(){

            @Override
            public int compare(PostfixNode a, PostfixNode b) {
                return a.getLevel() - b.getLevel();
            }
        });
    }

    public void addSuffixes(String postfix, int parent, int level) {
        this.addSuffixes(postfix, parent, level, null);
    }

    public void addSuffixes(String postfix, int parent, int level, String postcode) {
        PostfixNode node = new PostfixNode(postfix, parent, level, postcode);
        this.addSuffixes(node, postcode);
    }

    public void addSuffixes(String postfix, int parent, int id, int level, String postcode) {
        PostfixNode node = new PostfixNode(postfix, parent, id, level, postcode);
        this.addSuffixes(node, postcode);
    }

    public String toString() {
        if (this.suffixes.size() == 0) {
            return this.regionPrefix;
        }
        StringBuffer buffer = new StringBuffer();
        String LS = System.getProperty("line.separator");
        boolean first = true;
        for (PostfixNode suffix : this.suffixes) {
            if (first) {
                first = false;
                buffer.append(String.valueOf(this.regionPrefix) + suffix.toString());
                continue;
            }
            buffer.append(String.valueOf(LS) + this.regionPrefix + suffix.toString());
        }
        return buffer.toString();
    }
}

