/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maxmind.geoip2.model.AbstractCountryResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractCityResponse
extends AbstractCountryResponse {
    @JsonProperty
    private final City city = new City();
    @JsonProperty
    private final Location location = new Location();
    @JsonProperty
    private final Postal postal = new Postal();
    @JsonProperty(value="subdivisions")
    private final ArrayList<Subdivision> subdivisions = new ArrayList();

    AbstractCityResponse() {
    }

    public City getCity() {
        return this.city;
    }

    public Location getLocation() {
        return this.location;
    }

    public Postal getPostal() {
        return this.postal;
    }

    public List<Subdivision> getSubdivisions() {
        return new ArrayList<Subdivision>(this.subdivisions);
    }

    @JsonIgnore
    public Subdivision getMostSpecificSubdivision() {
        if (this.subdivisions.isEmpty()) {
            return new Subdivision();
        }
        return this.subdivisions.get(this.subdivisions.size() - 1);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + (this.getCity() != null ? "getCity()=" + this.getCity() + ", " : "") + (this.getLocation() != null ? "getLocation()=" + this.getLocation() + ", " : "") + (this.getPostal() != null ? "getPostal()=" + this.getPostal() + ", " : "") + (this.getSubdivisions() != null ? "getSubdivisionsList()=" + this.getSubdivisions() + ", " : "") + (this.getContinent() != null ? "getContinent()=" + this.getContinent() + ", " : "") + (this.getCountry() != null ? "getCountry()=" + this.getCountry() + ", " : "") + (this.getRegisteredCountry() != null ? "getRegisteredCountry()=" + this.getRegisteredCountry() + ", " : "") + (this.getRepresentedCountry() != null ? "getRepresentedCountry()=" + this.getRepresentedCountry() + ", " : "") + (this.getTraits() != null ? "getTraits()=" + this.getTraits() : "") + "]";
    }
}

