/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class EventSubscriptionDeclaration
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String eventName;
    protected final String eventType;
    protected boolean async;
    protected String activityId;
    protected boolean isStartEvent;
    protected String configuration;

    public EventSubscriptionDeclaration(String eventName, String eventType) {
        this.eventName = eventName;
        this.eventType = eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public boolean isStartEvent() {
        return this.isStartEvent;
    }

    public void setStartEvent(boolean isStartEvent) {
        this.isStartEvent = isStartEvent;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public EventSubscriptionEntity prepareEventSubscriptionEntity(ExecutionEntity execution) {
        EventSubscriptionEntity eventSubscriptionEntity = null;
        if (this.eventType.equals("message")) {
            eventSubscriptionEntity = new MessageEventSubscriptionEntity(execution);
        } else if (this.eventType.equals("signal")) {
            eventSubscriptionEntity = new SignalEventSubscriptionEntity(execution);
        } else {
            throw new ActivitiIllegalArgumentException("Found event definition of unknown type: " + this.eventType);
        }
        eventSubscriptionEntity.setEventName(this.eventName);
        if (this.activityId != null) {
            ActivityImpl activity = execution.getProcessDefinition().findActivity(this.activityId);
            eventSubscriptionEntity.setActivity(activity);
        }
        if (this.configuration != null) {
            eventSubscriptionEntity.setConfiguration(this.configuration);
        }
        return eventSubscriptionEntity;
    }
}

