/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper;

import com.github.pagehelper.Dialect;
import com.github.pagehelper.Page;
import com.github.pagehelper.SqlUtil;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PageHelper
implements Interceptor {
    private SqlUtil sqlUtil;
    private Properties properties;
    private Boolean autoDialect;

    public static Page startPage(int pageNum, int pageSize) {
        return PageHelper.startPage(pageNum, pageSize, true);
    }

    public static Page startPage(int pageNum, int pageSize, boolean count) {
        return PageHelper.startPage(pageNum, pageSize, count, null);
    }

    public static Page startPage(int pageNum, int pageSize, String orderBy) {
        Page page = PageHelper.startPage(pageNum, pageSize);
        page.setOrderBy(orderBy);
        return page;
    }

    public static Page offsetPage(int offset, int limit) {
        return PageHelper.offsetPage(offset, limit, true);
    }

    public static Page offsetPage(int offset, int limit, boolean count) {
        Page page = new Page(new int[]{offset, limit}, count);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static Page offsetPage(int offset, int limit, String orderBy) {
        Page page = PageHelper.offsetPage(offset, limit);
        page.setOrderBy(orderBy);
        return page;
    }

    public static Page startPage(int pageNum, int pageSize, boolean count, Boolean reasonable) {
        return PageHelper.startPage(pageNum, pageSize, count, reasonable, null);
    }

    public static Page startPage(int pageNum, int pageSize, boolean count, Boolean reasonable, Boolean pageSizeZero) {
        Page page = new Page(pageNum, pageSize, count);
        page.setReasonable(reasonable);
        page.setPageSizeZero(pageSizeZero);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static Page startPage(Object params) {
        Page page = SqlUtil.getPageFromObject(params);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static void orderBy(String orderBy) {
        Page page = SqlUtil.getLocalPage();
        if (page != null) {
            page.setOrderBy(orderBy);
        } else {
            page = new Page();
            page.setOrderBy(orderBy);
            page.setOrderByOnly(true);
            SqlUtil.setLocalPage(page);
        }
    }

    public static String getOrderBy() {
        Page page = SqlUtil.getLocalPage();
        if (page != null) {
            String orderBy = page.getOrderBy();
            if (orderBy == null || orderBy.length() == 0) {
                return null;
            }
            return orderBy;
        }
        return null;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.autoDialect.booleanValue()) {
            this.initSqlUtil(invocation);
        }
        return this.sqlUtil.processPage(invocation);
    }

    public synchronized void initSqlUtil(Invocation invocation) {
        if (this.sqlUtil == null) {
            String url = null;
            try {
                MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
                MetaObject msObject = SystemMetaObject.forObject((Object)ms);
                DataSource dataSource = (DataSource)msObject.getValue("configuration.environment.dataSource");
                url = dataSource.getConnection().getMetaData().getURL();
            }
            catch (SQLException e) {
                throw new RuntimeException("\u5206\u9875\u63d2\u4ef6\u521d\u59cb\u5316\u5f02\u5e38:" + e.getMessage());
            }
            if (url == null || url.length() == 0) {
                throw new RuntimeException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl\uff0c\u8bf7\u5728\u5206\u9875\u63d2\u4ef6\u4e2d\u914d\u7f6edialect\u53c2\u6570!");
            }
            String dialect = Dialect.fromJdbcUrl(url);
            if (dialect == null) {
                throw new RuntimeException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u901a\u8fc7dialect\u53c2\u6570\u6307\u5b9a!");
            }
            this.sqlUtil = new SqlUtil(dialect);
            this.sqlUtil.setProperties(this.properties);
            this.properties = null;
            this.autoDialect = false;
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties p) {
        try {
            Class.forName("org.apache.ibatis.scripting.xmltags.SqlNode");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u60a8\u4f7f\u7528\u7684MyBatis\u7248\u672c\u592a\u4f4e\uff0cMyBatis\u5206\u9875\u63d2\u4ef6PageHelper\u652f\u6301MyBatis3.2.0\u53ca\u4ee5\u4e0a\u7248\u672c!");
        }
        String dialect = p.getProperty("dialect");
        if (dialect == null || dialect.length() == 0) {
            this.autoDialect = true;
            this.properties = p;
        } else {
            this.autoDialect = false;
            this.sqlUtil = new SqlUtil(dialect);
            this.sqlUtil.setProperties(p);
        }
    }
}

